/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.action;

import com.liferay.portal.kernel.portlet.BaseConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class ConfigurationActionImpl
extends BaseConfigurationAction {
    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (!cmd.equals("update")) {
            return;
        }
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest, (String)portletResource);
        String tabs2 = ParamUtil.getString((PortletRequest)actionRequest, (String)"tabs2");
        if (tabs2.equals("display-settings")) {
            this.updateDisplaySettings(actionRequest, preferences);
        } else if (tabs2.equals("email-from")) {
            this.updateEmailFrom(actionRequest, preferences);
        } else if (tabs2.equals("event-reminder-email")) {
            this.updateEmailEventReminder(actionRequest, preferences);
        }
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            preferences.store();
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(portletConfig.getPortletName()) + ".doConfigure"));
        }
    }

    public String render(PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return "/html/portlet/calendar/configuration.jsp";
    }

    protected void updateDisplaySettings(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String tabs1Default = ParamUtil.getString((PortletRequest)actionRequest, (String)"tabs1Default");
        String summaryTabOrientation = ParamUtil.getString((PortletRequest)actionRequest, (String)"summaryTabOrientation");
        String summaryTabShowMiniMonth = ParamUtil.getString((PortletRequest)actionRequest, (String)"summaryTabShowMiniMonth");
        String summaryTabShowTodaysEvents = ParamUtil.getString((PortletRequest)actionRequest, (String)"summaryTabShowTodaysEvents");
        boolean enableComments = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enableComments");
        preferences.setValue("tabs1-default", tabs1Default);
        preferences.setValue("summary-tab-orientation", summaryTabOrientation);
        preferences.setValue("summary-tab-show-mini-month", summaryTabShowMiniMonth);
        preferences.setValue("summary-tab-show-todays-events", summaryTabShowTodaysEvents);
        preferences.setValue("enable-comments", String.valueOf(enableComments));
    }

    protected void updateEmailFrom(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String emailFromName = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailFromName");
        String emailFromAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailFromAddress");
        if (Validator.isNull((String)emailFromName)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailFromName");
        } else if (!Validator.isEmailAddress((String)emailFromAddress)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailFromAddress");
        } else {
            preferences.setValue("email-from-name", emailFromName);
            preferences.setValue("email-from-address", emailFromAddress);
        }
    }

    protected void updateEmailEventReminder(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        boolean emailEventReminderEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"emailEventReminderEnabled");
        String emailEventReminderSubject = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailEventReminderSubject");
        String emailEventReminderBody = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailEventReminderBody");
        if (Validator.isNull((String)emailEventReminderSubject)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailEventReminderSubject");
        } else if (Validator.isNull((String)emailEventReminderBody)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailEventReminderBody");
        } else {
            preferences.setValue("email-event-reminder-enabled", String.valueOf(emailEventReminderEnabled));
            preferences.setValue("email-event-reminder-subject", emailEventReminderSubject);
            preferences.setValue("email-event-reminder-body", emailEventReminderBody);
        }
    }
}

