/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.blogs.asset.BlogsEntryAssetRenderer;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.portlet.blogs.service.BlogsEntryServiceUtil;
import com.liferay.portlet.blogs.service.permission.BlogsEntryPermission;
import com.liferay.portlet.blogs.service.permission.BlogsPermission;
import javax.portlet.PortletURL;

public class BlogsEntryAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String CLASS_NAME = BlogsEntry.class.getName();
    public static final String TYPE = "blog";

    public AssetRenderer getAssetRenderer(long classPK, int type) throws PortalException, SystemException {
        BlogsEntry entry = BlogsEntryLocalServiceUtil.getEntry((long)classPK);
        return new BlogsEntryAssetRenderer(entry);
    }

    public AssetRenderer getAssetRenderer(long groupId, String urlTitle) throws PortalException, SystemException {
        BlogsEntry entry = BlogsEntryServiceUtil.getEntry((long)groupId, (String)urlTitle);
        return new BlogsEntryAssetRenderer(entry);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("THEME_DISPLAY");
        LiferayPortletURL addAssetURL = null;
        if (BlogsPermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "ADD_ENTRY")) {
            addAssetURL = liferayPortletResponse.createRenderURL("33");
            addAssetURL.setParameter("struts_action", "/blogs/edit_entry");
        }
        return addAssetURL;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return BlogsEntryPermission.contains(permissionChecker, classPK, actionId);
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/blogs/blogs.png";
    }
}

