/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.action;

import com.liferay.portal.kernel.portlet.BaseConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class ConfigurationActionImpl
extends BaseConfigurationAction {
    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (!cmd.equals("update")) {
            return;
        }
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest, (String)portletResource);
        String tabs2 = ParamUtil.getString((PortletRequest)actionRequest, (String)"tabs2");
        if (tabs2.equals("display-settings")) {
            this.updateDisplaySettings(actionRequest, preferences);
        } else if (tabs2.equals("email-from")) {
            this.updateEmailFrom(actionRequest, preferences);
        } else if (tabs2.equals("entry-added-email")) {
            this.updateEmailEntryAdded(actionRequest, preferences);
        } else if (tabs2.equals("entry-updated-email")) {
            this.updateEmailEntryUpdated(actionRequest, preferences);
        } else if (tabs2.equals("rss")) {
            this.updateRSS(actionRequest, preferences);
        }
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            preferences.store();
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(portletConfig.getPortletName()) + ".doConfigure"));
        }
    }

    public String render(PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return "/html/portlet/blogs/configuration.jsp";
    }

    protected void updateDisplaySettings(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        int pageDelta = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"pageDelta");
        String pageDisplayStyle = ParamUtil.getString((PortletRequest)actionRequest, (String)"pageDisplayStyle");
        boolean enableFlags = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enableFlags");
        boolean enableRatings = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enableRatings");
        boolean enableComments = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enableComments");
        boolean enableCommentRatings = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enableCommentRatings");
        preferences.setValue("page-delta", String.valueOf(pageDelta));
        preferences.setValue("page-display-style", pageDisplayStyle);
        preferences.setValue("enable-flags", String.valueOf(enableFlags));
        preferences.setValue("enable-ratings", String.valueOf(enableRatings));
        preferences.setValue("enable-comments", String.valueOf(enableComments));
        preferences.setValue("enable-comment-ratings", String.valueOf(enableCommentRatings));
    }

    protected void updateEmailFrom(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String emailFromName = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailFromName");
        String emailFromAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailFromAddress");
        if (Validator.isNull((String)emailFromName)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailFromName");
        } else if (!Validator.isEmailAddress((String)emailFromAddress) && !Validator.isVariableTerm((String)emailFromAddress)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailFromAddress");
        } else {
            preferences.setValue("email-from-name", emailFromName);
            preferences.setValue("email-from-address", emailFromAddress);
        }
    }

    protected void updateEmailEntryAdded(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        boolean emailEntryAddedEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"emailEntryAddedEnabled");
        String emailEntryAddedSubject = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailEntryAddedSubject");
        String emailEntryAddedBody = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailEntryAddedBody");
        if (Validator.isNull((String)emailEntryAddedSubject)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailEntryAddedSubject");
        } else if (Validator.isNull((String)emailEntryAddedBody)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailEntryAddedBody");
        } else {
            preferences.setValue("email-entry-added-enabled", String.valueOf(emailEntryAddedEnabled));
            preferences.setValue("email-entry-added-subject", emailEntryAddedSubject);
            preferences.setValue("email-entry-added-body", emailEntryAddedBody);
        }
    }

    protected void updateEmailEntryUpdated(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        boolean emailEntryUpdatedEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"emailEntryUpdatedEnabled");
        String emailEntryUpdatedSubject = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailEntryUpdatedSubject");
        String emailEntryUpdatedBody = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailEntryUpdatedBody");
        if (Validator.isNull((String)emailEntryUpdatedSubject)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailEntryUpdatedSubject");
        } else if (Validator.isNull((String)emailEntryUpdatedBody)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailEntryUpdatedBody");
        } else {
            preferences.setValue("email-entry-updated-enabled", String.valueOf(emailEntryUpdatedEnabled));
            preferences.setValue("email-entry-updated-subject", emailEntryUpdatedSubject);
            preferences.setValue("email-entry-updated-body", emailEntryUpdatedBody);
        }
    }

    protected void updateRSS(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        int rssDelta = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"rssDelta");
        String rssDisplayStyle = ParamUtil.getString((PortletRequest)actionRequest, (String)"rssDisplayStyle");
        String rssFormat = ParamUtil.getString((PortletRequest)actionRequest, (String)"rssFormat");
        preferences.setValue("rss-delta", String.valueOf(rssDelta));
        preferences.setValue("rss-display-style", rssDisplayStyle);
        preferences.setValue("rss-format", rssFormat);
    }
}

