/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.announcements.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.announcements.model.AnnouncementsEntry;
import com.liferay.portlet.announcements.service.AnnouncementsEntryLocalServiceUtil;

public class AnnouncementsEntryPermission {
    public static void check(PermissionChecker permissionChecker, AnnouncementsEntry entry, String actionId) throws PortalException {
        if (!AnnouncementsEntryPermission.contains(permissionChecker, entry, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException, SystemException {
        if (!AnnouncementsEntryPermission.contains(permissionChecker, entryId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, AnnouncementsEntry entry, String actionId) {
        if (permissionChecker.hasOwnerPermission(entry.getCompanyId(), AnnouncementsEntry.class.getName(), entry.getEntryId(), entry.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(0L, AnnouncementsEntry.class.getName(), entry.getEntryId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException, SystemException {
        AnnouncementsEntry entry = AnnouncementsEntryLocalServiceUtil.getEntry((long)entryId);
        return AnnouncementsEntryPermission.contains(permissionChecker, entry, actionId);
    }
}

