/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.announcements.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portlet.announcements.NoSuchDeliveryException;
import com.liferay.portlet.announcements.model.AnnouncementsDelivery;
import com.liferay.portlet.announcements.model.AnnouncementsEntryConstants;
import com.liferay.portlet.announcements.service.base.AnnouncementsDeliveryLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnouncementsDeliveryLocalServiceImpl
extends AnnouncementsDeliveryLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(AnnouncementsDeliveryLocalServiceImpl.class);

    public AnnouncementsDelivery addUserDelivery(long userId, String type) throws PortalException, SystemException {
        AnnouncementsDelivery delivery;
        block3: {
            User user = this.userPersistence.findByPrimaryKey(userId);
            long deliveryId = this.counterLocalService.increment();
            delivery = this.announcementsDeliveryPersistence.create(deliveryId);
            delivery.setCompanyId(user.getCompanyId());
            delivery.setUserId(user.getUserId());
            delivery.setType(type);
            delivery.setEmail(false);
            delivery.setSms(false);
            delivery.setWebsite(true);
            try {
                this.announcementsDeliveryPersistence.update((BaseModel)delivery, false);
            }
            catch (SystemException se) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Add failed, fetch {userId=" + userId + ", type=" + type + "}"));
                }
                if ((delivery = this.announcementsDeliveryPersistence.fetchByU_T(userId, type, false)) != null) break block3;
                throw se;
            }
        }
        return delivery;
    }

    public void deleteDeliveries(long userId) throws SystemException {
        this.announcementsDeliveryPersistence.removeByUserId(userId);
    }

    public void deleteDelivery(long deliveryId) throws PortalException, SystemException {
        this.announcementsDeliveryPersistence.remove(deliveryId);
    }

    public void deleteDelivery(long userId, String type) throws SystemException {
        try {
            this.announcementsDeliveryPersistence.removeByU_T(userId, type);
        }
        catch (NoSuchDeliveryException noSuchDeliveryException) {}
    }

    public AnnouncementsDelivery getDelivery(long deliveryId) throws PortalException, SystemException {
        return this.announcementsDeliveryPersistence.findByPrimaryKey(deliveryId);
    }

    public List<AnnouncementsDelivery> getUserDeliveries(long userId) throws PortalException, SystemException {
        ArrayList<AnnouncementsDelivery> deliveries = new ArrayList<AnnouncementsDelivery>(AnnouncementsEntryConstants.TYPES.length);
        String[] stringArray = AnnouncementsEntryConstants.TYPES;
        int n = AnnouncementsEntryConstants.TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            deliveries.add(this.getUserDelivery(userId, type));
            ++n2;
        }
        return deliveries;
    }

    public AnnouncementsDelivery getUserDelivery(long userId, String type) throws PortalException, SystemException {
        AnnouncementsDelivery delivery = this.announcementsDeliveryPersistence.fetchByU_T(userId, type);
        if (delivery == null) {
            delivery = this.announcementsDeliveryLocalService.addUserDelivery(userId, type);
        }
        return delivery;
    }

    public AnnouncementsDelivery updateDelivery(long userId, String type, boolean email, boolean sms, boolean website) throws PortalException, SystemException {
        AnnouncementsDelivery delivery = this.getUserDelivery(userId, type);
        delivery.setEmail(email);
        delivery.setSms(sms);
        delivery.setWebsite(website);
        this.announcementsDeliveryPersistence.update((BaseModel)delivery, false);
        return delivery;
    }
}

