/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletMode;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PortletPreferencesIds;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortalPreferencesImpl;
import com.liferay.portlet.PortletPreferencesFactory;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.PortletPreferencesWrapper;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PreferencesValidator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class PortletPreferencesFactoryImpl
implements PortletPreferencesFactory {
    public PortletPreferences getLayoutPortletSetup(Layout layout, String portletId) throws SystemException {
        long ownerId = 0L;
        int ownerType = 3;
        return PortletPreferencesLocalServiceUtil.getPreferences((long)layout.getCompanyId(), (long)ownerId, (int)ownerType, (long)layout.getPlid(), (String)portletId);
    }

    public PortalPreferences getPortalPreferences(HttpServletRequest request) throws SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        long ownerId = themeDisplay.getUserId();
        int ownerType = 4;
        long plid = 0L;
        String portletId = "LIFERAY_PORTAL";
        PortalPreferences portalPrefs = null;
        if (themeDisplay.isSignedIn()) {
            PortletPreferencesImpl preferencesImpl = (PortletPreferencesImpl)PortletPreferencesLocalServiceUtil.getPreferences((long)themeDisplay.getCompanyId(), (long)ownerId, (int)ownerType, (long)plid, (String)portletId);
            portalPrefs = new PortalPreferencesImpl(preferencesImpl, themeDisplay.isSignedIn());
        } else {
            HttpSession session = request.getSession();
            portalPrefs = (PortalPreferences)session.getAttribute("PORTAL_PREFERENCES");
            if (portalPrefs == null) {
                PortletPreferencesImpl preferencesImpl = (PortletPreferencesImpl)PortletPreferencesLocalServiceUtil.getPreferences((long)themeDisplay.getCompanyId(), (long)ownerId, (int)ownerType, (long)plid, (String)portletId);
                preferencesImpl = (PortletPreferencesImpl)preferencesImpl.clone();
                portalPrefs = new PortalPreferencesImpl(preferencesImpl, themeDisplay.isSignedIn());
                session.setAttribute("PORTAL_PREFERENCES", (Object)portalPrefs);
            }
        }
        return portalPrefs;
    }

    public PortalPreferences getPortalPreferences(PortletRequest portletRequest) throws SystemException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return this.getPortalPreferences(request);
    }

    public PortletPreferences getPortletPreferences(HttpServletRequest request, String portletId) throws PortalException, SystemException {
        PortletPreferencesIds portletPreferencesIds = this.getPortletPreferencesIds(request, portletId);
        return PortletPreferencesLocalServiceUtil.getPreferences((PortletPreferencesIds)portletPreferencesIds);
    }

    public PortletPreferencesIds getPortletPreferencesIds(HttpServletRequest request, String portletId) throws PortalException, SystemException {
        Layout layout = (Layout)request.getAttribute("LAYOUT");
        return this.getPortletPreferencesIds(request, layout, portletId);
    }

    public PortletPreferencesIds getPortletPreferencesIds(HttpServletRequest request, Layout selLayout, String portletId) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
        long ownerId = 0L;
        int ownerType = 0;
        long plid = 0L;
        boolean modeEditGuest = false;
        String portletMode = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_mode");
        if (portletMode.equals(LiferayPortletMode.EDIT_GUEST.toString()) || layoutTypePortlet != null && layoutTypePortlet.hasModeEditGuestPortletId(portletId)) {
            modeEditGuest = true;
        }
        if (modeEditGuest) {
            boolean hasUpdateLayoutPermission = LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"UPDATE");
            if (layout.isPrivateLayout() || !hasUpdateLayoutPermission) {
                throw new PrincipalException();
            }
        }
        if (portlet.isPreferencesCompanyWide()) {
            ownerId = themeDisplay.getCompanyId();
            ownerType = 1;
            plid = 0L;
            portletId = PortletConstants.getRootPortletId((String)portletId);
        } else if (portlet.isPreferencesUniquePerLayout()) {
            ownerId = 0L;
            ownerType = 3;
            plid = selLayout.getPlid();
            if (!portlet.isPreferencesOwnedByGroup()) {
                long userId = PortalUtil.getUserId((HttpServletRequest)request);
                if (userId <= 0L || modeEditGuest) {
                    userId = UserLocalServiceUtil.getDefaultUserId((long)themeDisplay.getCompanyId());
                }
                ownerId = userId;
                ownerType = 4;
            }
        } else {
            plid = 0L;
            if (portlet.isPreferencesOwnedByGroup()) {
                ownerId = themeDisplay.getScopeGroupId();
                ownerType = 2;
                portletId = PortletConstants.getRootPortletId((String)portletId);
            } else {
                long userId = PortalUtil.getUserId((HttpServletRequest)request);
                if (userId <= 0L || modeEditGuest) {
                    userId = UserLocalServiceUtil.getDefaultUserId((long)themeDisplay.getCompanyId());
                }
                ownerId = userId;
                ownerType = 4;
            }
        }
        return new PortletPreferencesIds(themeDisplay.getCompanyId(), ownerId, ownerType, plid, portletId);
    }

    public PortletPreferences getPortletSetup(Layout layout, String portletId, String defaultPreferences) throws SystemException {
        return this.getPortletSetup(0L, layout, portletId, defaultPreferences);
    }

    public PortletPreferences getPortletSetup(HttpServletRequest request, String portletId) throws SystemException {
        return this.getPortletSetup(request, portletId, null);
    }

    public PortletPreferences getPortletSetup(HttpServletRequest request, String portletId, String defaultPreferences) throws SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        return this.getPortletSetup(themeDisplay.getScopeGroupId(), themeDisplay.getLayout(), portletId, defaultPreferences);
    }

    public PortletPreferences getPortletSetup(PortletRequest portletRequest) throws SystemException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        String portletId = PortalUtil.getPortletId((PortletRequest)portletRequest);
        return this.getPortletSetup(request, portletId);
    }

    public PortletPreferences getPortletSetup(PortletRequest portletRequest, String portletId) throws SystemException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return this.getPortletSetup(request, portletId);
    }

    public PortletPreferences getPreferences(HttpServletRequest request) {
        PortletRequest portletRequest = (PortletRequest)request.getAttribute("javax.portlet.request");
        PortletPreferencesImpl preferences = null;
        if (portletRequest != null) {
            PortletPreferencesWrapper preferencesWrapper = (PortletPreferencesWrapper)portletRequest.getPreferences();
            preferences = preferencesWrapper.getPreferencesImpl();
        }
        return preferences;
    }

    public PreferencesValidator getPreferencesValidator(Portlet portlet) {
        return PortalUtil.getPreferencesValidator((Portlet)portlet);
    }

    protected PortletPreferences getPortletSetup(long scopeGroupId, Layout layout, String portletId, String defaultPreferences) throws SystemException {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)layout.getCompanyId(), (String)portletId);
        boolean uniquePerLayout = false;
        boolean uniquePerGroup = false;
        if (portlet.isPreferencesCompanyWide()) {
            portletId = PortletConstants.getRootPortletId((String)portletId);
        } else if (portlet.isPreferencesUniquePerLayout()) {
            uniquePerLayout = true;
            if (portlet.isPreferencesOwnedByGroup()) {
                uniquePerGroup = true;
            }
        } else if (portlet.isPreferencesOwnedByGroup()) {
            uniquePerGroup = true;
            portletId = PortletConstants.getRootPortletId((String)portletId);
        }
        long ownerId = 0L;
        int ownerType = 3;
        long plid = layout.getPlid();
        if (!uniquePerLayout) {
            plid = 0L;
            if (uniquePerGroup) {
                ownerId = scopeGroupId > 0L ? scopeGroupId : layout.getGroupId();
                ownerType = 2;
            } else {
                ownerId = layout.getCompanyId();
                ownerType = 1;
            }
        }
        return PortletPreferencesLocalServiceUtil.getPreferences((long)layout.getCompanyId(), (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)defaultPreferences);
    }
}

