/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portlet.InvokerPortlet;
import com.liferay.portlet.PortletBagFactory;
import com.liferay.portlet.PortletConfigFactoryUtil;
import com.liferay.portlet.PortletContextFactory;
import com.liferay.portlet.PortletInstanceFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.servlet.ServletContext;

public class PortletInstanceFactoryImpl
implements PortletInstanceFactory {
    private InvokerPortlet _internalInvokerPortletPrototype;
    private Map<String, Map<String, InvokerPortlet>> _pool = new ConcurrentHashMap<String, Map<String, InvokerPortlet>>();

    public void clear(Portlet portlet) {
        this.clear(portlet, true);
    }

    public void clear(Portlet portlet, boolean resetRemotePortletBag) {
        Map<String, InvokerPortlet> portletInstances = this._pool.get(portlet.getRootPortletId());
        if (portletInstances != null) {
            for (Map.Entry<String, InvokerPortlet> entry : portletInstances.entrySet()) {
                String portletId = entry.getKey();
                InvokerPortlet invokerPortletInstance = entry.getValue();
                if (PortletConstants.getInstanceId((String)portletId) != null) continue;
                invokerPortletInstance.destroy();
                break;
            }
        }
        this._pool.remove(portlet.getRootPortletId());
        PortletApp portletApp = portlet.getPortletApp();
        if (resetRemotePortletBag && portletApp.isWARFile()) {
            PortletBagPool.remove((String)portlet.getRootPortletId());
        }
    }

    public InvokerPortlet create(Portlet portlet, ServletContext servletContext) throws PortletException {
        PortletConfig portletConfig;
        Map<String, InvokerPortlet> portletInstances;
        boolean instanceable = false;
        if (portlet.isInstanceable() && PortletConstants.getInstanceId((String)portlet.getPortletId()) != null) {
            instanceable = true;
        }
        if ((portletInstances = this._pool.get(portlet.getRootPortletId())) == null) {
            portletInstances = new ConcurrentHashMap<String, InvokerPortlet>();
            this._pool.put(portlet.getRootPortletId(), portletInstances);
        }
        InvokerPortlet instanceInvokerPortletInstance = null;
        if (instanceable) {
            instanceInvokerPortletInstance = portletInstances.get(portlet.getPortletId());
        }
        InvokerPortlet rootInvokerPortletInstance = null;
        if (instanceInvokerPortletInstance == null && (rootInvokerPortletInstance = portletInstances.get(portlet.getRootPortletId())) == null) {
            PortletBag portletBag = PortletBagPool.get((String)portlet.getRootPortletId());
            if (portletBag == null) {
                PortletBagFactory portletBagFactory = new PortletBagFactory();
                portletBagFactory.setClassLoader(PortalClassLoaderUtil.getClassLoader());
                portletBagFactory.setServletContext(servletContext);
                portletBagFactory.setWARFile(false);
                try {
                    portletBag = portletBagFactory.create(portlet);
                }
                catch (Exception e) {
                    throw new PortletException((Throwable)e);
                }
            }
            portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
            rootInvokerPortletInstance = this.init(portlet, portletConfig, portletBag.getPortletInstance());
            portletInstances.put(portlet.getRootPortletId(), rootInvokerPortletInstance);
        }
        if (instanceable) {
            if (instanceInvokerPortletInstance == null) {
                javax.portlet.Portlet portletInstance = rootInvokerPortletInstance.getPortletInstance();
                portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
                PortletContext portletContext = portletConfig.getPortletContext();
                boolean checkAuthToken = rootInvokerPortletInstance.isCheckAuthToken();
                boolean facesPortlet = rootInvokerPortletInstance.isFacesPortlet();
                boolean strutsPortlet = rootInvokerPortletInstance.isStrutsPortlet();
                boolean strutsBridgePortlet = rootInvokerPortletInstance.isStrutsBridgePortlet();
                instanceInvokerPortletInstance = this._internalInvokerPortletPrototype.create(portlet, portletInstance, portletConfig, portletContext, checkAuthToken, facesPortlet, strutsPortlet, strutsBridgePortlet);
                portletInstances.put(portlet.getPortletId(), instanceInvokerPortletInstance);
            }
        } else if (rootInvokerPortletInstance != null) {
            instanceInvokerPortletInstance = rootInvokerPortletInstance;
        }
        return instanceInvokerPortletInstance;
    }

    public void destroy() {
    }

    public void destroy(Portlet portlet) {
        this.clear(portlet);
        PortletConfigFactoryUtil.destroy((Portlet)portlet);
        PortletContextFactory.destroy(portlet);
        PortletLocalServiceUtil.destroyPortlet((Portlet)portlet);
    }

    public void setInternalInvokerPortletPrototype(InvokerPortlet internalInvokerPortletPrototype) {
        this._internalInvokerPortletPrototype = internalInvokerPortletPrototype;
    }

    protected InvokerPortlet init(Portlet portlet, PortletConfig portletConfig, javax.portlet.Portlet portletInstance) throws PortletException {
        PortletContext portletContext = portletConfig.getPortletContext();
        InvokerPortlet invokerPortlet = this._internalInvokerPortletPrototype.create(portlet, portletInstance, portletContext);
        invokerPortlet.init(portletConfig);
        return invokerPortlet;
    }
}

