/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.NoSuchCompanyException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Image;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.imagegallery.NoSuchImageException;
import com.liferay.portlet.imagegallery.service.IGImageLocalServiceUtil;
import com.liferay.portlet.journal.NoSuchArticleImageException;
import com.liferay.portlet.journal.NoSuchTemplateException;
import com.liferay.portlet.journal.service.JournalArticleImageLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalTemplateLocalServiceUtil;
import com.liferay.portlet.shopping.NoSuchItemException;
import com.liferay.portlet.shopping.service.ShoppingItemLocalServiceUtil;
import com.liferay.portlet.softwarecatalog.NoSuchProductScreenshotException;
import com.liferay.portlet.softwarecatalog.service.SCProductScreenshotLocalServiceUtil;
import java.util.List;

public class VerifyImage
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyImage.class);

    protected void doVerify() throws Exception {
        List images = ImageLocalServiceUtil.getImages();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + images.size() + " stale images"));
        }
        for (Image image : images) {
            if (!this.isStaleImage(image)) continue;
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Deleting stale image " + image.getImageId()));
            }
            ImageLocalServiceUtil.deleteImage((long)image.getImageId());
        }
    }

    protected boolean isStaleImage(Image image) throws Exception {
        long imageId = image.getImageId();
        try {
            CompanyLocalServiceUtil.getCompanyByLogoId((long)imageId);
            return false;
        }
        catch (NoSuchCompanyException noSuchCompanyException) {
            try {
                LayoutLocalServiceUtil.getLayoutByIconImageId((long)imageId);
                return false;
            }
            catch (NoSuchLayoutException noSuchLayoutException) {
                try {
                    UserLocalServiceUtil.getUserByPortraitId((long)imageId);
                    return false;
                }
                catch (NoSuchUserException noSuchUserException) {
                    try {
                        IGImageLocalServiceUtil.getImageBySmallImageId((long)imageId);
                        return false;
                    }
                    catch (NoSuchImageException noSuchImageException) {
                        try {
                            IGImageLocalServiceUtil.getImageByLargeImageId((long)imageId);
                            return false;
                        }
                        catch (NoSuchImageException noSuchImageException2) {
                            try {
                                IGImageLocalServiceUtil.getImageByCustom1ImageId((long)imageId);
                                return false;
                            }
                            catch (NoSuchImageException noSuchImageException3) {
                                try {
                                    IGImageLocalServiceUtil.getImageByCustom2ImageId((long)imageId);
                                    return false;
                                }
                                catch (NoSuchImageException noSuchImageException4) {
                                    List journalArticles = JournalArticleLocalServiceUtil.getArticlesBySmallImageId((long)imageId);
                                    if (journalArticles.size() > 0) {
                                        return false;
                                    }
                                    try {
                                        JournalArticleImageLocalServiceUtil.getArticleImage((long)imageId);
                                        return false;
                                    }
                                    catch (NoSuchArticleImageException noSuchArticleImageException) {
                                        try {
                                            JournalTemplateLocalServiceUtil.getTemplateBySmallImageId((long)imageId);
                                            return false;
                                        }
                                        catch (NoSuchTemplateException noSuchTemplateException) {
                                            try {
                                                SCProductScreenshotLocalServiceUtil.getProductScreenshotByFullImageId((long)imageId);
                                                return false;
                                            }
                                            catch (NoSuchProductScreenshotException noSuchProductScreenshotException) {
                                                try {
                                                    SCProductScreenshotLocalServiceUtil.getProductScreenshotByThumbnailId((long)imageId);
                                                    return false;
                                                }
                                                catch (NoSuchProductScreenshotException noSuchProductScreenshotException2) {
                                                    try {
                                                        ShoppingItemLocalServiceUtil.getItemByLargeImageId((long)imageId);
                                                        return false;
                                                    }
                                                    catch (NoSuchItemException noSuchItemException) {
                                                        try {
                                                            ShoppingItemLocalServiceUtil.getItemByMediumImageId((long)imageId);
                                                            return false;
                                                        }
                                                        catch (NoSuchItemException noSuchItemException2) {
                                                            try {
                                                                ShoppingItemLocalServiceUtil.getItemBySmallImageId((long)imageId);
                                                                return false;
                                                            }
                                                            catch (NoSuchItemException noSuchItemException3) {
                                                                return true;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

