/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.Digester;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.PropsValues;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;

public class DigesterImpl
implements Digester {
    private static final boolean _BASE_64 = PropsValues.PASSWORDS_DIGEST_ENCODING.equals("base64");
    private static Log _log = LogFactoryUtil.getLog(Digester.class);

    public String digest(String text) {
        return this.digest("SHA", text);
    }

    public String digest(String algorithm, String ... text) {
        if (_BASE_64) {
            return this.digestBase64(algorithm, text);
        }
        return this.digestHex(algorithm, text);
    }

    public String digestBase64(String text) {
        return this.digestBase64("SHA", text);
    }

    public String digestBase64(String algorithm, String ... text) {
        byte[] bytes = this.digestRaw(algorithm, text);
        return Base64.encode((byte[])bytes);
    }

    public String digestHex(String text) {
        return this.digestHex("SHA", text);
    }

    public String digestHex(String algorithm, String ... text) {
        byte[] bytes = this.digestRaw(algorithm, text);
        return Hex.encodeHexString((byte[])bytes);
    }

    public byte[] digestRaw(String text) {
        return this.digestRaw("SHA", text);
    }

    public byte[] digestRaw(String algorithm, String ... text) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(algorithm);
            StringBundler sb = new StringBundler(text.length * 2 - 1);
            String[] stringArray = text;
            int n = text.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                if (sb.length() > 0) {
                    sb.append(":");
                }
                sb.append(t);
                ++n2;
            }
            String s = sb.toString();
            messageDigest.update(s.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException nsae) {
            _log.error((Object)nsae, (Throwable)nsae);
        }
        catch (UnsupportedEncodingException uee) {
            _log.error((Object)uee, (Throwable)uee);
        }
        return messageDigest.digest();
    }
}

