/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v5_2_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.dao.jdbc.SmartResultSet;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portlet.asset.NoSuchTagException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class UpgradeTags
extends UpgradeProcess {
    private Map<String, Long> _entryIdsMap = new HashMap<String, Long>();

    protected void addEntry(long entryId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long parentEntryId, String name, long vocabularyId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("insert into TagsEntry (entryId, groupId, companyId, userId, userName, createDate, modifiedDate, parentEntryId, name, vocabularyId) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            ps.setLong(1, entryId);
            ps.setLong(2, groupId);
            ps.setLong(3, companyId);
            ps.setLong(4, userId);
            ps.setString(5, userName);
            ps.setTimestamp(6, createDate);
            ps.setTimestamp(7, modifiedDate);
            ps.setLong(8, parentEntryId);
            ps.setString(9, name);
            ps.setLong(10, vocabularyId);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void addProperty(long propertyId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long entryId, String key, String value) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("insert into TagsProperty (propertyId, companyId, userId, userName, createDate, modifiedDate, entryId, key_, value) values (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            ps.setLong(1, propertyId);
            ps.setLong(2, companyId);
            ps.setLong(3, userId);
            ps.setString(4, userName);
            ps.setTimestamp(5, createDate);
            ps.setTimestamp(6, modifiedDate);
            ps.setLong(7, entryId);
            ps.setString(8, key);
            ps.setString(9, value);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected long copyEntry(long groupId, long entryId) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block3: {
            long l;
            String key = String.valueOf(groupId) + "_" + entryId;
            Long newEntryId = this._entryIdsMap.get(key);
            if (newEntryId != null) {
                return newEntryId;
            }
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getConnection();
                ps = con.prepareStatement("select * from TagsEntry where entryId = ?", 1004, 1007);
                ps.setLong(1, entryId);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                String userName = rs.getString("userName");
                Timestamp createDate = rs.getTimestamp("createDate");
                Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                long parentEntryId = rs.getLong("parentEntryId");
                String name = rs.getString("name");
                long vocabularyId = rs.getLong("vocabularyId");
                newEntryId = this.increment();
                this.addEntry(newEntryId, groupId, companyId, userId, userName, createDate, modifiedDate, parentEntryId, name, vocabularyId);
                this.copyProperties(entryId, newEntryId);
                this._entryIdsMap.put(key, newEntryId);
                l = newEntryId;
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return l;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        throw new NoSuchTagException("No AssetTag exists with the primary key " + entryId);
    }

    public void copyProperties(long entryId, long newEntryId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select * from TagsProperty where entryId = ?", 1004, 1007);
            ps.setLong(1, entryId);
            rs = ps.executeQuery();
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                String userName = rs.getString("userName");
                Timestamp createDate = rs.getTimestamp("createDate");
                Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                String key = rs.getString("key_");
                String value = rs.getString("value");
                long newPropertyId = this.increment();
                this.addProperty(newPropertyId, companyId, userId, userName, createDate, modifiedDate, newEntryId, key, value);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void deleteEntries() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select entryId from TagsEntry where groupId = 0");
            rs = ps.executeQuery();
            while (rs.next()) {
                long entryId = rs.getLong("entryId");
                this.runSQL("delete from TagsAssets_TagsEntries where entryId = " + entryId);
                this.runSQL("delete from TagsProperty where entryId = " + entryId);
            }
            this.runSQL("delete from TagsEntry where groupId = 0");
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void doUpgrade() throws Exception {
        this.updateGroupIds();
        this.updateAssets();
    }

    protected void updateAssets() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select resourcePrimKey from JournalArticle where approved = ?");
            ps.setBoolean(1, false);
            rs = ps.executeQuery();
            while (rs.next()) {
                long resourcePrimKey = rs.getLong("resourcePrimKey");
                this.runSQL("update TagsAsset set visible = FALSE where classPK = " + resourcePrimKey);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateGroupIds() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select TA.assetId, TA.groupId, TA_TE.entryId from TagsAssets_TagsEntries TA_TE inner join TagsAsset TA on TA.assetId = TA_TE.assetId", 1004, 1007);
            rs = ps.executeQuery();
            SmartResultSet srs = new SmartResultSet(rs);
            while (srs.next()) {
                long assetId = srs.getLong("TA.assetId");
                long groupId = srs.getLong("TA.groupId");
                long entryId = srs.getLong("TA_TE.entryId");
                long newEntryId = this.copyEntry(groupId, entryId);
                this.runSQL("insert into TagsAssets_TagsEntries (assetId, entryId) values (" + assetId + ", " + newEntryId + ")");
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        this.deleteEntries();
    }
}

