/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.samplesqlbuilder;

import com.liferay.counter.model.Counter;
import com.liferay.counter.model.impl.CounterModelImpl;
import com.liferay.portal.kernel.util.IntegerWrapper;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.ClassName;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.model.Permission;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.ResourceCode;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.ClassNameImpl;
import com.liferay.portal.model.impl.CompanyImpl;
import com.liferay.portal.model.impl.ContactImpl;
import com.liferay.portal.model.impl.GroupImpl;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.model.impl.PermissionImpl;
import com.liferay.portal.model.impl.ResourceCodeImpl;
import com.liferay.portal.model.impl.ResourceImpl;
import com.liferay.portal.model.impl.RoleImpl;
import com.liferay.portal.model.impl.UserImpl;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.impl.AssetEntryImpl;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.model.BlogsStatsUser;
import com.liferay.portlet.blogs.model.impl.BlogsEntryImpl;
import com.liferay.portlet.blogs.model.impl.BlogsStatsUserImpl;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBDiscussion;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBStatsUser;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.impl.MBCategoryImpl;
import com.liferay.portlet.messageboards.model.impl.MBDiscussionImpl;
import com.liferay.portlet.messageboards.model.impl.MBMessageImpl;
import com.liferay.portlet.messageboards.model.impl.MBStatsUserImpl;
import com.liferay.portlet.messageboards.model.impl.MBThreadImpl;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.impl.WikiNodeImpl;
import com.liferay.portlet.wiki.model.impl.WikiPageImpl;
import com.liferay.util.SimpleCounter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataFactory {
    private Role _administratorRole;
    private ClassName _blogsEntryClassName;
    private List<ClassName> _classNames;
    private Role _communityAdministratorRole;
    private Role _communityMemberRole;
    private Role _communityOwnerRole;
    private Company _company;
    private SimpleCounter _counter;
    private List<CounterModelImpl> _counters;
    private User _defaultUser;
    private ClassName _groupClassName;
    private List<Group> _groups;
    private Group _guestGroup;
    private Role _guestRole;
    private Map<String, Long> _individualResourceCodeIds;
    private Map<Long, String> _individualResourceNames;
    private int _maxGroupsCount;
    private int _maxUserToGroupCount;
    private Role _organizationAdministratorRole;
    private Role _organizationMemberRole;
    private Role _organizationOwnerRole;
    private Role _ownerRole;
    private SimpleCounter _permissionCounter;
    private Role _powerUserRole;
    private SimpleCounter _resourceCodeCounter;
    private List<ResourceCode> _resourceCodes;
    private SimpleCounter _resourceCounter;
    private ClassName _roleClassName;
    private List<Role> _roles;
    private ClassName _userClassName;
    private Object[] _userNames;
    private Role _userRole;
    private ClassName _wikiPageClassName;

    public DataFactory(int maxGroupsCount, int maxUserToGroupCount, SimpleCounter counter, SimpleCounter permissionCounter, SimpleCounter resourceCounter, SimpleCounter resourceCodeCounter) {
        try {
            this._maxGroupsCount = maxGroupsCount;
            this._maxUserToGroupCount = maxUserToGroupCount;
            this._counter = counter;
            this._permissionCounter = permissionCounter;
            this._resourceCounter = resourceCounter;
            this._resourceCodeCounter = resourceCodeCounter;
            this.initClassNames();
            this.initCompany();
            this.initDefaultUser();
            this.initGroups();
            this.initResourceCodes();
            this.initRoles();
            this.initUserNames();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AssetEntry addAssetEntry(long groupId, long userId, long classNameId, long classPK, String mimeType, String title) throws Exception {
        AssetEntryImpl assetEntry = new AssetEntryImpl();
        assetEntry.setGroupId(groupId);
        assetEntry.setUserId(userId);
        assetEntry.setClassNameId(classNameId);
        assetEntry.setClassPK(classPK);
        assetEntry.setMimeType(mimeType);
        assetEntry.setTitle(title);
        return assetEntry;
    }

    public BlogsEntry addBlogsEntry(long groupId, long userId, String title, String urlTitle, String content) throws Exception {
        BlogsEntryImpl blogsEntry = new BlogsEntryImpl();
        blogsEntry.setEntryId(this._counter.get());
        blogsEntry.setGroupId(groupId);
        blogsEntry.setUserId(userId);
        blogsEntry.setTitle(title);
        blogsEntry.setUrlTitle(urlTitle);
        blogsEntry.setContent(content);
        return blogsEntry;
    }

    public BlogsStatsUser addBlogsStatsUser(long groupId, long userId) throws Exception {
        BlogsStatsUserImpl blogsStatsUser = new BlogsStatsUserImpl();
        blogsStatsUser.setGroupId(groupId);
        blogsStatsUser.setUserId(userId);
        return blogsStatsUser;
    }

    public Contact addContact(String firstName, String lastName) throws Exception {
        ContactImpl contact = new ContactImpl();
        contact.setContactId(this._counter.get());
        contact.setAccountId(this._company.getAccountId());
        contact.setFirstName(firstName);
        contact.setLastName(lastName);
        return contact;
    }

    public Group addGroup(long groupId, long classNameId, long classPK, String name, String friendlyURL) throws Exception {
        GroupImpl group = new GroupImpl();
        group.setGroupId(groupId);
        group.setClassNameId(classNameId);
        group.setClassPK(classPK);
        group.setName(name);
        group.setFriendlyURL(friendlyURL);
        return group;
    }

    public Layout addLayout(int layoutId, String name, String friendlyURL, String column1, String column2) throws Exception {
        LayoutImpl layout = new LayoutImpl();
        layout.setPlid(this._counter.get());
        layout.setPrivateLayout(false);
        layout.setLayoutId(layoutId);
        layout.setName(name);
        layout.setFriendlyURL(friendlyURL);
        UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
        typeSettingsProperties.setProperty("layout-template-id", "2_columns_ii");
        typeSettingsProperties.setProperty("column-1", column1);
        typeSettingsProperties.setProperty("column-2", column2);
        String typeSettings = StringUtil.replace((String)typeSettingsProperties.toString(), (String)"\n", (String)"\\n");
        layout.setTypeSettings(typeSettings);
        return layout;
    }

    public MBCategory addMBCategory(long categoryId, long groupId, long companyId, long userId, String name, String description, int threadCount, int messageCount) throws Exception {
        MBCategoryImpl mbCategory = new MBCategoryImpl();
        mbCategory.setCategoryId(categoryId);
        mbCategory.setGroupId(groupId);
        mbCategory.setCompanyId(companyId);
        mbCategory.setUserId(userId);
        mbCategory.setName(name);
        mbCategory.setDescription(description);
        mbCategory.setThreadCount(threadCount);
        mbCategory.setMessageCount(messageCount);
        return mbCategory;
    }

    public MBDiscussion addMBDiscussion(long classNameId, long classPK, long threadId) throws Exception {
        MBDiscussionImpl mbDiscussion = new MBDiscussionImpl();
        mbDiscussion.setDiscussionId(this._counter.get());
        mbDiscussion.setClassNameId(classNameId);
        mbDiscussion.setClassPK(classPK);
        mbDiscussion.setThreadId(threadId);
        return mbDiscussion;
    }

    public MBMessage addMBMessage(long messageId, long groupId, long userId, long classNameId, long classPK, long categoryId, long threadId, long parentMessageId, String subject, String body) throws Exception {
        MBMessageImpl mbMessage = new MBMessageImpl();
        mbMessage.setMessageId(messageId);
        mbMessage.setGroupId(groupId);
        mbMessage.setUserId(userId);
        mbMessage.setClassNameId(classNameId);
        mbMessage.setClassPK(classPK);
        mbMessage.setCategoryId(categoryId);
        mbMessage.setThreadId(threadId);
        mbMessage.setParentMessageId(parentMessageId);
        mbMessage.setSubject(subject);
        mbMessage.setBody(body);
        return mbMessage;
    }

    public MBStatsUser addMBStatsUser(long groupId, long userId) throws Exception {
        MBStatsUserImpl mbStatsUser = new MBStatsUserImpl();
        mbStatsUser.setGroupId(groupId);
        mbStatsUser.setUserId(userId);
        return mbStatsUser;
    }

    public MBThread addMBThread(long threadId, long groupId, long categoryId, long rootMessageId, int messageCount, long lastPostByUserId) throws Exception {
        MBThreadImpl mbThread = new MBThreadImpl();
        mbThread.setThreadId(threadId);
        mbThread.setGroupId(groupId);
        mbThread.setCategoryId(categoryId);
        mbThread.setRootMessageId(rootMessageId);
        mbThread.setMessageCount(messageCount);
        mbThread.setLastPostByUserId(lastPostByUserId);
        return mbThread;
    }

    public List<Permission> addPermissions(Resource resource) throws Exception {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        String name = this._individualResourceNames.get(resource.getCodeId());
        List<String> actions = ResourceActionsUtil.getModelResourceActions(name);
        for (String action : actions) {
            PermissionImpl permission = new PermissionImpl();
            permission.setPermissionId(this._permissionCounter.get());
            permission.setCompanyId(this._company.getCompanyId());
            permission.setActionId(action);
            permission.setResourceId(resource.getResourceId());
            permissions.add(permission);
        }
        return permissions;
    }

    public Resource addResource(String name, String primKey) throws Exception {
        Long codeId = this._individualResourceCodeIds.get(name);
        ResourceImpl resource = new ResourceImpl();
        resource.setResourceId(this._resourceCounter.get());
        resource.setCodeId(codeId);
        resource.setPrimKey(primKey);
        return resource;
    }

    public List<KeyValuePair> addRolesPermissions(Resource resource, List<Permission> permissions, Role memberRole) throws Exception {
        KeyValuePair kvp;
        ArrayList<KeyValuePair> rolesPermissions = new ArrayList<KeyValuePair>();
        for (Permission permission : permissions) {
            KeyValuePair kvp2 = new KeyValuePair();
            kvp2.setKey(String.valueOf(this._ownerRole.getRoleId()));
            kvp2.setValue(String.valueOf(permission.getPermissionId()));
            rolesPermissions.add(kvp2);
        }
        String name = this._individualResourceNames.get(resource.getCodeId());
        if (memberRole != null) {
            List<String> communityDefaultactions = ResourceActionsUtil.getModelResourceCommunityDefaultActions(name);
            for (Permission permission : permissions) {
                if (!communityDefaultactions.contains(permission.getActionId())) continue;
                kvp = new KeyValuePair();
                kvp.setKey(String.valueOf(memberRole.getRoleId()));
                kvp.setValue(String.valueOf(permission.getPermissionId()));
                rolesPermissions.add(kvp);
            }
        }
        List<String> guestDefaultactions = ResourceActionsUtil.getModelResourceGuestDefaultActions(name);
        for (Permission permission : permissions) {
            if (!guestDefaultactions.contains(permission.getActionId())) continue;
            kvp = new KeyValuePair();
            kvp.setKey(String.valueOf(this._guestRole.getRoleId()));
            kvp.setValue(String.valueOf(permission.getPermissionId()));
            rolesPermissions.add(kvp);
        }
        return rolesPermissions;
    }

    public User addUser(boolean defaultUser, String screenName) throws Exception {
        UserImpl user = new UserImpl();
        user.setUserId(this._counter.get());
        user.setDefaultUser(defaultUser);
        if (Validator.isNull((String)screenName)) {
            screenName = String.valueOf(user.getUserId());
        }
        user.setScreenName(screenName);
        String emailAddress = String.valueOf(screenName) + "@liferay.com";
        user.setEmailAddress(emailAddress);
        return user;
    }

    public List<Long> addUserToGroupIds(long groupId) {
        ArrayList<Long> groupIds = new ArrayList<Long>(this._maxUserToGroupCount + 1);
        groupIds.add(this._guestGroup.getGroupId());
        if (groupId + (long)this._maxUserToGroupCount > (long)this._maxGroupsCount) {
            groupId = groupId - (long)this._maxUserToGroupCount + 1L;
        }
        int i = 0;
        while (i < this._maxUserToGroupCount) {
            groupIds.add(groupId + (long)i);
            ++i;
        }
        return groupIds;
    }

    public WikiNode addWikiNode(long groupId, long userId, String name, String description) throws Exception {
        WikiNodeImpl wikiNode = new WikiNodeImpl();
        wikiNode.setNodeId(this._counter.get());
        wikiNode.setGroupId(groupId);
        wikiNode.setUserId(userId);
        wikiNode.setName(name);
        wikiNode.setDescription(description);
        return wikiNode;
    }

    public WikiPage addWikiPage(long groupId, long userId, long nodeId, String title, double version, String content, boolean head) throws Exception {
        WikiPageImpl wikiPage = new WikiPageImpl();
        wikiPage.setPageId(this._counter.get());
        wikiPage.setResourcePrimKey(this._counter.get());
        wikiPage.setGroupId(groupId);
        wikiPage.setUserId(userId);
        wikiPage.setNodeId(nodeId);
        wikiPage.setTitle(title);
        wikiPage.setVersion(version);
        wikiPage.setContent(content);
        wikiPage.setHead(head);
        return wikiPage;
    }

    public Role getAdministratorRole() {
        return this._administratorRole;
    }

    public ClassName getBlogsEntryClassName() {
        return this._blogsEntryClassName;
    }

    public List<ClassName> getClassNames() {
        return this._classNames;
    }

    public Role getCommunityAdministratorRole() {
        return this._communityAdministratorRole;
    }

    public Role getCommunityMemberRole() {
        return this._communityMemberRole;
    }

    public Role getCommunityOwnerRole() {
        return this._communityOwnerRole;
    }

    public Company getCompany() {
        return this._company;
    }

    public List<CounterModelImpl> getCounters() {
        return this._counters;
    }

    public User getDefaultUser() {
        return this._defaultUser;
    }

    public ClassName getGroupClassName() {
        return this._groupClassName;
    }

    public List<Group> getGroups() {
        return this._groups;
    }

    public Group getGuestGroup() {
        return this._guestGroup;
    }

    public Role getGuestRole() {
        return this._guestRole;
    }

    public Role getOrganizationAdministratorRole() {
        return this._organizationAdministratorRole;
    }

    public Role getOrganizationMemberRole() {
        return this._organizationMemberRole;
    }

    public Role getOrganizationOwnerRole() {
        return this._organizationOwnerRole;
    }

    public Role getPowerUserRole() {
        return this._powerUserRole;
    }

    public List<ResourceCode> getResourceCodes() {
        return this._resourceCodes;
    }

    public ClassName getRoleClassName() {
        return this._roleClassName;
    }

    public List<Role> getRoles() {
        return this._roles;
    }

    public ClassName getUserClassName() {
        return this._userClassName;
    }

    public Object[] getUserNames() {
        return this._userNames;
    }

    public Role getUserRole() {
        return this._userRole;
    }

    public ClassName getWikiPageClassName() {
        return this._wikiPageClassName;
    }

    public void initClassNames() throws Exception {
        if (this._classNames != null) {
            return;
        }
        this._classNames = new ArrayList<ClassName>();
        List models = ModelHintsUtil.getModels();
        for (String model : models) {
            ClassNameImpl className = new ClassNameImpl();
            className.setClassNameId(this._counter.get());
            className.setValue(model);
            this._classNames.add(className);
            if (model.equals(BlogsEntry.class.getName())) {
                this._blogsEntryClassName = className;
            }
            if (model.equals(Group.class.getName())) {
                this._groupClassName = className;
                continue;
            }
            if (model.equals(Role.class.getName())) {
                this._roleClassName = className;
                continue;
            }
            if (model.equals(User.class.getName())) {
                this._userClassName = className;
                continue;
            }
            if (!model.equals(WikiPage.class.getName())) continue;
            this._wikiPageClassName = className;
        }
    }

    public void initCompany() throws Exception {
        this._company = new CompanyImpl();
        this._company.setCompanyId(this._counter.get());
        this._company.setAccountId(this._counter.get());
    }

    public void initCounters() throws Exception {
        if (this._counters != null) {
            return;
        }
        this._counters = new ArrayList<CounterModelImpl>();
        CounterModelImpl counter = new CounterModelImpl();
        counter.setName(Counter.class.getName());
        counter.setCurrentId(this._counter.get());
        this._counters.add(counter);
        counter = new CounterModelImpl();
        counter.setName(Permission.class.getName());
        counter.setCurrentId(this._permissionCounter.get());
        this._counters.add(counter);
        counter = new CounterModelImpl();
        counter.setName(Resource.class.getName());
        counter.setCurrentId(this._resourceCounter.get());
        this._counters.add(counter);
        counter = new CounterModelImpl();
        counter.setName(ResourceCode.class.getName());
        counter.setCurrentId(this._resourceCodeCounter.get());
        this._counters.add(counter);
    }

    public void initDefaultUser() throws Exception {
        this._defaultUser = new UserImpl();
        this._defaultUser.setUserId(this._counter.get());
    }

    public void initGroups() throws Exception {
        if (this._groups != null) {
            return;
        }
        this._groups = new ArrayList<Group>();
        GroupImpl group = new GroupImpl();
        group.setGroupId(this._counter.get());
        group.setClassNameId(this._groupClassName.getClassNameId());
        group.setClassPK(group.getGroupId());
        group.setName("Guest");
        group.setFriendlyURL("/guest");
        this._groups.add(group);
        this._guestGroup = group;
    }

    public void initResourceCodes() throws Exception {
        if (this._resourceCodes != null) {
            return;
        }
        this._resourceCodes = new ArrayList<ResourceCode>();
        this._individualResourceCodeIds = new HashMap<String, Long>();
        this._individualResourceNames = new HashMap<Long, String>();
        List models = ModelHintsUtil.getModels();
        for (String model : models) {
            this.initResourceCodes(model);
        }
        Document doc = SAXReaderUtil.read((File)new File("../portal-web/docroot/WEB-INF/portlet-custom.xml"), (boolean)false);
        Element root = doc.getRootElement();
        for (Element portlet : root.elements("portlet")) {
            String portletName = portlet.elementText("portlet-name");
            this.initResourceCodes(portletName);
        }
    }

    public void initResourceCodes(String name) throws Exception {
        ResourceCode resourceCode = this.newResourceCode();
        resourceCode.setName(name);
        resourceCode.setScope(1);
        this._resourceCodes.add(resourceCode);
        resourceCode = this.newResourceCode();
        resourceCode.setName(name);
        resourceCode.setScope(2);
        this._resourceCodes.add(resourceCode);
        resourceCode = this.newResourceCode();
        resourceCode.setName(name);
        resourceCode.setScope(3);
        this._resourceCodes.add(resourceCode);
        resourceCode = this.newResourceCode();
        resourceCode.setName(name);
        resourceCode.setScope(4);
        this._resourceCodes.add(resourceCode);
        this._individualResourceCodeIds.put(name, resourceCode.getCodeId());
        this._individualResourceNames.put(resourceCode.getCodeId(), name);
    }

    public void initRoles() throws Exception {
        if (this._roles != null) {
            return;
        }
        this._roles = new ArrayList<Role>();
        Role role = this.newRole();
        role.setName("Administrator");
        role.setType(1);
        this._roles.add(role);
        this._administratorRole = role;
        role = this.newRole();
        role.setName("Community Administrator");
        role.setType(2);
        this._roles.add(role);
        this._communityAdministratorRole = role;
        role = this.newRole();
        role.setName("Community Member");
        role.setType(2);
        this._roles.add(role);
        this._communityMemberRole = role;
        role = this.newRole();
        role.setName("Community Owner");
        role.setType(2);
        this._roles.add(role);
        this._communityOwnerRole = role;
        role = this.newRole();
        role.setName("Guest");
        role.setType(1);
        this._roles.add(role);
        this._guestRole = role;
        role = this.newRole();
        role.setName("Organization Administrator");
        role.setType(3);
        this._roles.add(role);
        this._communityAdministratorRole = role;
        role = this.newRole();
        role.setName("Organization Member");
        role.setType(3);
        this._roles.add(role);
        this._communityMemberRole = role;
        role = this.newRole();
        role.setName("Organization Owner");
        role.setType(3);
        this._roles.add(role);
        this._communityOwnerRole = role;
        role = this.newRole();
        role.setName("Owner");
        role.setType(1);
        this._roles.add(role);
        this._ownerRole = role;
        role = this.newRole();
        role.setName("Power User");
        role.setType(1);
        this._roles.add(role);
        this._powerUserRole = role;
        role = this.newRole();
        role.setName("User");
        role.setType(1);
        this._roles.add(role);
        this._userRole = role;
    }

    public void initUserNames() throws Exception {
        if (this._userNames != null) {
            return;
        }
        this._userNames = new Object[2];
        String dependenciesDir = "../portal-impl/src/com/liferay/portal/tools/samplesqlbuilder/dependencies/";
        List firstNames = ListUtil.fromFile((String)(String.valueOf(dependenciesDir) + "first_names.txt"));
        List lastNames = ListUtil.fromFile((String)(String.valueOf(dependenciesDir) + "last_names.txt"));
        this._userNames[0] = firstNames;
        this._userNames[1] = lastNames;
    }

    public IntegerWrapper newInteger() {
        return new IntegerWrapper();
    }

    protected ResourceCode newResourceCode() {
        ResourceCodeImpl resourceCode = new ResourceCodeImpl();
        resourceCode.setCodeId(this._resourceCodeCounter.get());
        return resourceCode;
    }

    protected Role newRole() {
        RoleImpl role = new RoleImpl();
        role.setRoleId(this._counter.get());
        role.setClassNameId(this._roleClassName.getClassNameId());
        role.setClassPK(role.getRoleId());
        return role;
    }
}

