/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.jspc.resin;

import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.StackTraceUtil;
import com.liferay.portal.util.FileImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchJspCompiler {
    private static FileImpl _fileUtil = FileImpl.getInstance();
    private String _appDir;
    private String _classDir;

    public static void main(String[] args) {
        if (args.length != 2) {
            throw new IllegalArgumentException();
        }
        new BatchJspCompiler(args[0], args[1]);
    }

    public BatchJspCompiler(String appDir, String classDir) {
        try {
            this._appDir = appDir;
            this._classDir = classDir;
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(appDir);
            ds.setIncludes(new String[]{"**\\*.jsp"});
            ds.scan();
            Object[] files = ds.getIncludedFiles();
            Arrays.sort(files);
            ArrayList<String> fileNames = new ArrayList<String>();
            int i = 0;
            while (i < files.length) {
                Object fileName = files[i];
                fileNames.add((String)fileName);
                if (i > 0 && i % 200 == 0 || i + 1 == files.length) {
                    this._compile(fileNames);
                    fileNames.clear();
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void _compile(List<String> fileNames) throws Exception {
        if (fileNames.size() == 0) {
            return;
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-app-dir");
        arguments.add(this._appDir);
        arguments.add("-class-dir");
        arguments.add(this._classDir);
        arguments.addAll(fileNames);
        MethodKey methodKey = new MethodKey("com.caucho.jsp.JspCompiler", "main", new Class[]{String[].class});
        MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{arguments.toArray(new String[arguments.size()])});
        try {
            methodHandler.invoke(false);
        }
        catch (Exception e) {
            _fileUtil.write(String.valueOf(this._appDir) + "/../jspc_error", StackTraceUtil.getStackTrace((Throwable)e));
        }
    }
}

