/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.deploy;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.tools.deploy.DeploymentHandler;
import com.liferay.portal.tools.deploy.StartProgressListener;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;

public class DeploymentProgressListener
implements ProgressListener {
    private static Log _log = LogFactoryUtil.getLog(DeploymentProgressListener.class);
    private DeploymentHandler _deploymentHandler;
    private String _warContext;
    private DeploymentManager _deploymentManager;

    public DeploymentProgressListener(DeploymentHandler deploymentHandler, String warContext) {
        this._deploymentHandler = deploymentHandler;
        this._warContext = warContext;
        this._deploymentManager = this._deploymentHandler.getDeploymentManager();
    }

    public void handleProgressEvent(ProgressEvent progressEvent) {
        block11: {
            DeploymentStatus deploymentStatus = progressEvent.getDeploymentStatus();
            if (_log.isInfoEnabled()) {
                _log.info((Object)deploymentStatus.getMessage());
            }
            if (deploymentStatus.isCompleted()) {
                try {
                    TargetModuleID[] targetModuleIDs = this._deploymentManager.getNonRunningModules(ModuleType.WAR, this._deploymentManager.getTargets());
                    if (targetModuleIDs != null && targetModuleIDs.length > 0) {
                        TargetModuleID[] targetModuleIDArray = targetModuleIDs;
                        int n = targetModuleIDs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TargetModuleID targetModuleID = targetModuleIDArray[n2];
                            if (this._warContext.equals(targetModuleID.getModuleID())) {
                                ProgressObject startProgress = this._deploymentManager.start(new TargetModuleID[]{targetModuleID});
                                startProgress.addProgressListener((ProgressListener)new StartProgressListener(this._deploymentHandler));
                                this._deploymentHandler.setError(false);
                                this._deploymentHandler.setStarted(true);
                                break block11;
                            }
                            ++n2;
                        }
                        break block11;
                    }
                    TargetModuleID[] targetModuleIDArray = targetModuleIDs = this._deploymentManager.getAvailableModules(ModuleType.WAR, this._deploymentManager.getTargets());
                    int n = targetModuleIDs.length;
                    int n3 = 0;
                    while (n3 < n) {
                        TargetModuleID targetModuleID = targetModuleIDArray[n3];
                        if (this._warContext.equals(targetModuleID.getModuleID())) {
                            ProgressObject startProgress = this._deploymentManager.start(new TargetModuleID[]{targetModuleID});
                            startProgress.addProgressListener((ProgressListener)new StartProgressListener(this._deploymentHandler));
                            this._deploymentHandler.setError(false);
                            this._deploymentHandler.setStarted(true);
                            break;
                        }
                        ++n3;
                    }
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                    this._deploymentHandler.setError(true);
                    this._deploymentHandler.setStarted(false);
                }
            } else if (deploymentStatus.isFailed()) {
                this._deploymentHandler.setError(true);
                this._deploymentHandler.setStarted(false);
            }
        }
    }
}

