/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.util.HtmlImpl;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.xml.DocumentImpl;
import com.liferay.util.xml.XMLMerger;
import com.liferay.util.xml.descriptor.WebXML23Descriptor;
import com.liferay.util.xml.descriptor.WebXML24Descriptor;
import com.liferay.util.xml.descriptor.XMLDescriptor;
import java.io.IOException;

public class WebXMLBuilder {
    public static void main(String[] args) {
        InitUtil.initWithSpring();
        if (args.length != 3) {
            throw new IllegalArgumentException();
        }
        new WebXMLBuilder(args[0], args[1], args[2]);
    }

    public static String organizeWebXML(String webXML) throws DocumentException, IOException {
        HtmlImpl html = new HtmlImpl();
        webXML = html.stripComments(webXML);
        double version = 2.3;
        Document doc = SAXReaderUtil.read((String)webXML);
        Element root = doc.getRootElement();
        version = GetterUtil.getDouble((String)root.attributeValue("version"), (double)version);
        XMLMerger merger = null;
        merger = version == 2.3 ? new XMLMerger((XMLDescriptor)new WebXML23Descriptor()) : new XMLMerger((XMLDescriptor)new WebXML24Descriptor());
        DocumentImpl docImpl = (DocumentImpl)doc;
        merger.organizeXML(docImpl.getWrappedDocument());
        webXML = doc.formattedString();
        return webXML;
    }

    public WebXMLBuilder(String originalWebXML, String customWebXML, String mergedWebXML) {
        try {
            String customContent = FileUtil.read((String)customWebXML);
            int x = customContent.indexOf("<web-app");
            x = customContent.indexOf(">", x) + 1;
            int y = customContent.indexOf("</web-app>");
            customContent = customContent.substring(x, y);
            String originalContent = FileUtil.read((String)originalWebXML);
            int z = originalContent.indexOf("<web-app");
            z = originalContent.indexOf(">", z) + 1;
            String mergedContent = String.valueOf(originalContent.substring(0, z)) + customContent + originalContent.substring(z, originalContent.length());
            mergedContent = WebXMLBuilder.organizeWebXML(mergedContent);
            FileUtil.write((String)mergedWebXML, (String)mergedContent, (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

