/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.util.InitUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class WSDDMerger {
    public static void main(String[] args) {
        InitUtil.initWithSpring();
        new WSDDMerger(args[0], args[1]);
    }

    public static void merge(String source, String destination) throws DocumentException, IOException {
        String name;
        File sourceFile = new File(source);
        Document doc = SAXReaderUtil.read((File)sourceFile);
        Element root = doc.getRootElement();
        List sourceServices = root.elements("service");
        if (sourceServices.size() == 0) {
            return;
        }
        File destinationFile = new File(destination);
        doc = SAXReaderUtil.read((File)destinationFile);
        root = doc.getRootElement();
        TreeMap<String, Element> servicesMap = new TreeMap<String, Element>();
        for (Element service : root.elements("service")) {
            name = service.attributeValue("name");
            servicesMap.put(name, service);
            service.detach();
        }
        for (Element service : sourceServices) {
            name = service.attributeValue("name");
            servicesMap.put(name, service);
            service.detach();
        }
        for (Map.Entry entry : servicesMap.entrySet()) {
            Element service = (Element)entry.getValue();
            root.add(service);
        }
        String content = doc.formattedString();
        content = StringUtil.replace((String)content, (String)"\"/>", (String)"\" />");
        FileUtil.write((String)destination, (String)content, (boolean)true);
    }

    public WSDDMerger(String source, String destination) {
        try {
            WSDDMerger.merge(source, destination);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

