/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.staging;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.RemoteExportException;
import com.liferay.portal.RemoteOptionsException;
import com.liferay.portal.kernel.cal.DayAndPosition;
import com.liferay.portal.kernel.cal.Duration;
import com.liferay.portal.kernel.cal.Recurrence;
import com.liferay.portal.kernel.cal.RecurrenceSerializer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageStatus;
import com.liferay.portal.kernel.staging.Staging;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.lar.LayoutExporter;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.GroupServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.http.GroupServiceHttp;
import com.liferay.portal.service.http.LayoutServiceHttp;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.communities.messaging.LayoutsLocalPublisherRequest;
import com.liferay.portlet.communities.messaging.LayoutsRemotePublisherRequest;
import com.liferay.portlet.tasks.service.TasksProposalLocalServiceUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.PortletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StagingImpl
implements Staging {
    public void copyFromLive(PortletRequest portletRequest) throws Exception {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        Group stagingGroup = GroupLocalServiceUtil.getGroup((long)stagingGroupId);
        long liveGroupId = stagingGroup.getLiveGroupId();
        Map<String, String[]> parameterMap = this.getStagingParameters(portletRequest);
        this.publishLayouts(portletRequest, liveGroupId, stagingGroupId, parameterMap, false);
    }

    public void copyFromLive(PortletRequest portletRequest, Portlet portlet) throws Exception {
        long plid = ParamUtil.getLong((PortletRequest)portletRequest, (String)"plid");
        Layout targetLayout = LayoutLocalServiceUtil.getLayout((long)plid);
        Group stagingGroup = targetLayout.getGroup();
        Group liveGroup = stagingGroup.getLiveGroup();
        Layout sourceLayout = LayoutLocalServiceUtil.getLayout((long)liveGroup.getGroupId(), (boolean)targetLayout.isPrivateLayout(), (long)targetLayout.getLayoutId());
        this.copyPortlet(portletRequest, liveGroup.getGroupId(), stagingGroup.getGroupId(), sourceLayout.getPlid(), targetLayout.getPlid(), portlet.getPortletId());
    }

    public void copyPortlet(PortletRequest portletRequest, long sourceGroupId, long targetGroupId, long sourcePlid, long targetPlid, String portletId) throws Exception {
        Map<String, String[]> parameterMap = this.getStagingParameters(portletRequest);
        File file = LayoutLocalServiceUtil.exportPortletInfoAsFile((long)sourcePlid, (long)sourceGroupId, (String)portletId, parameterMap, null, null);
        try {
            LayoutServiceUtil.importPortletInfo((long)targetPlid, (long)targetGroupId, (String)portletId, parameterMap, (File)file);
        }
        finally {
            file.delete();
        }
    }

    public void copyRemoteLayouts(long sourceGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> exportParameterMap, String remoteAddress, int remotePort, boolean secureConnection, long remoteGroupId, boolean remotePrivateLayout, Map<String, String[]> importParameterMap, Date startDate, Date endDate) throws Exception {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = UserLocalServiceUtil.getUser((long)permissionChecker.getUserId());
        StringBundler sb = new StringBundler(4);
        if (secureConnection) {
            sb.append("https://");
        } else {
            sb.append("http://");
        }
        sb.append(remoteAddress);
        sb.append(":");
        sb.append(remotePort);
        String url = sb.toString();
        HttpPrincipal httpPrincipal = new HttpPrincipal(url, user.getEmailAddress(), user.getPassword(), user.getPasswordEncrypted());
        try {
            GroupServiceHttp.getGroup(httpPrincipal, remoteGroupId);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            RemoteExportException ree = new RemoteExportException(2);
            ree.setGroupId(remoteGroupId);
            throw ree;
        }
        catch (SystemException systemException) {
            RemoteExportException ree = new RemoteExportException(1);
            ree.setURL(url);
            throw ree;
        }
        byte[] bytes = null;
        if (layoutIdMap == null) {
            bytes = LayoutServiceUtil.exportLayouts((long)sourceGroupId, (boolean)privateLayout, exportParameterMap, (Date)startDate, (Date)endDate);
        } else {
            ArrayList<Layout> layouts = new ArrayList<Layout>();
            for (Map.Entry<Long, Boolean> entry : layoutIdMap.entrySet()) {
                long plid = GetterUtil.getLong((String)String.valueOf(entry.getKey()));
                boolean includeChildren = entry.getValue();
                Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
                if (!layouts.contains(layout)) {
                    layouts.add(layout);
                }
                for (Layout parentLayout : this.getMissingParents(layout, sourceGroupId)) {
                    if (layouts.contains(parentLayout)) continue;
                    layouts.add(parentLayout);
                }
                if (!includeChildren) continue;
                for (Layout childLayout : layout.getAllChildren()) {
                    if (layouts.contains(childLayout)) continue;
                    layouts.add(childLayout);
                }
            }
            long[] layoutIds = new long[layouts.size()];
            int i = 0;
            while (i < layouts.size()) {
                Layout curLayout = (Layout)layouts.get(i);
                layoutIds[i] = curLayout.getLayoutId();
                ++i;
            }
            if (layoutIds.length <= 0) {
                throw new RemoteExportException(3);
            }
            bytes = LayoutServiceUtil.exportLayouts((long)sourceGroupId, (boolean)privateLayout, (long[])layoutIds, exportParameterMap, (Date)startDate, (Date)endDate);
        }
        LayoutServiceHttp.importLayouts(httpPrincipal, remoteGroupId, remotePrivateLayout, importParameterMap, bytes);
    }

    public List<Layout> getMissingParents(Layout layout, long liveGroupId) throws PortalException, SystemException {
        ArrayList<Layout> missingParents = new ArrayList<Layout>();
        long parentLayoutId = layout.getParentLayoutId();
        while (parentLayoutId > 0L) {
            try {
                LayoutLocalServiceUtil.getLayout((long)liveGroupId, (boolean)layout.isPrivateLayout(), (long)parentLayoutId);
                break;
            }
            catch (NoSuchLayoutException noSuchLayoutException) {
                Layout parent = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)parentLayoutId);
                missingParents.add(parent);
                parentLayoutId = parent.getParentLayoutId();
            }
        }
        return missingParents;
    }

    public String getSchedulerGroupName(String destinationName, long groupId) {
        return destinationName.concat("/").concat(String.valueOf(groupId));
    }

    public Map<String, String[]> getStagingParameters() {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        parameterMap.put("CATEGORIES", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("DATA_STRATEGY", new String[]{"DATA_STRATEGY_MIRROR"});
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("DELETE_PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("IGNORE_LAST_PUBLISH_DATE", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PERMISSIONS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_USER_PREFERENCES", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("THEME", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("USER_ID_STRATEGY", new String[]{"CURRENT_USER_ID"});
        parameterMap.put("USER_PERMISSIONS", new String[]{Boolean.FALSE.toString()});
        return parameterMap;
    }

    public Map<String, String[]> getStagingParameters(PortletRequest portletRequest) {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>(portletRequest.getParameterMap());
        if (!parameterMap.containsKey("DATA_STRATEGY")) {
            parameterMap.put("DATA_STRATEGY", new String[]{"DATA_STRATEGY_MIRROR"});
        }
        if (!parameterMap.containsKey("DELETE_MISSING_LAYOUTS")) {
            parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.TRUE.toString()});
        }
        if (!parameterMap.containsKey("DELETE_PORTLET_DATA")) {
            parameterMap.put("DELETE_PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
        }
        if (!parameterMap.containsKey("PORTLET_DATA")) {
            parameterMap.put("PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
        }
        if (!parameterMap.containsKey("PORTLET_DATA_ALL")) {
            parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.FALSE.toString()});
        }
        if (!parameterMap.containsKey("PORTLET_SETUP")) {
            parameterMap.put("PORTLET_SETUP", new String[]{Boolean.TRUE.toString()});
        }
        if (!parameterMap.containsKey("PORTLET_USER_PREFERENCES")) {
            parameterMap.put("PORTLET_USER_PREFERENCES", new String[]{Boolean.TRUE.toString()});
        }
        if (!parameterMap.containsKey("THEME")) {
            parameterMap.put("THEME", new String[]{Boolean.FALSE.toString()});
        }
        if (!parameterMap.containsKey("USER_ID_STRATEGY")) {
            parameterMap.put("USER_ID_STRATEGY", new String[]{"CURRENT_USER_ID"});
        }
        return parameterMap;
    }

    public void publishLayout(long plid, long liveGroupId, boolean includeChildren) throws Exception {
        Map<String, String[]> parameterMap = this.getStagingParameters();
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.FALSE.toString()});
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        layouts.add(layout);
        layouts.addAll(this.getMissingParents(layout, liveGroupId));
        if (includeChildren) {
            layouts.addAll(layout.getAllChildren());
        }
        Iterator itr = layouts.iterator();
        long[] layoutIds = new long[layouts.size()];
        int i = 0;
        while (itr.hasNext()) {
            Layout curLayout = (Layout)itr.next();
            layoutIds[i] = curLayout.getLayoutId();
            ++i;
        }
        this.publishLayouts(layout.getGroupId(), liveGroupId, layout.isPrivateLayout(), layoutIds, parameterMap, null, null);
    }

    public void publishLayouts(long sourceGroupId, long targetGroupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        File file = LayoutLocalServiceUtil.exportLayoutsAsFile((long)sourceGroupId, (boolean)privateLayout, (long[])layoutIds, parameterMap, (Date)startDate, (Date)endDate);
        try {
            LayoutServiceUtil.importLayouts((long)targetGroupId, (boolean)privateLayout, parameterMap, (File)file);
        }
        finally {
            file.delete();
        }
    }

    public void publishLayouts(long sourceGroupId, long targetGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.FALSE.toString()});
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        for (Map.Entry<Long, Boolean> entry : layoutIdMap.entrySet()) {
            long plid = GetterUtil.getLong((String)String.valueOf(entry.getKey()));
            boolean includeChildren = entry.getValue();
            Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
            if (!layouts.contains(layout)) {
                layouts.add(layout);
            }
            for (Layout parentLayout : this.getMissingParents(layout, targetGroupId)) {
                if (layouts.contains(parentLayout)) continue;
                layouts.add(parentLayout);
            }
            if (!includeChildren) continue;
            for (Layout childLayout : layout.getAllChildren()) {
                if (layouts.contains(childLayout)) continue;
                layouts.add(childLayout);
            }
        }
        long[] layoutIds = new long[layouts.size()];
        int i = 0;
        while (i < layouts.size()) {
            Layout curLayout = (Layout)layouts.get(i);
            layoutIds[i] = curLayout.getLayoutId();
            ++i;
        }
        this.publishLayouts(sourceGroupId, targetGroupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
    }

    public void publishLayouts(long sourceGroupId, long targetGroupId, boolean privateLayout, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        this.publishLayouts(sourceGroupId, targetGroupId, privateLayout, (long[])null, parameterMap, startDate, endDate);
    }

    public void publishToLive(PortletRequest portletRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId");
        Group liveGroup = GroupLocalServiceUtil.getGroup((long)groupId);
        Map<String, String[]> parameterMap = this.getStagingParameters(portletRequest);
        if (liveGroup.isStaged()) {
            if (liveGroup.isStagedRemotely()) {
                this.publishToRemote(portletRequest);
            } else {
                Group stagingGroup = liveGroup.getStagingGroup();
                this.publishLayouts(portletRequest, stagingGroup.getGroupId(), groupId, parameterMap, false);
            }
        }
    }

    public void publishToLive(PortletRequest portletRequest, Portlet portlet) throws Exception {
        long plid = ParamUtil.getLong((PortletRequest)portletRequest, (String)"plid");
        Layout sourceLayout = LayoutLocalServiceUtil.getLayout((long)plid);
        Group stagingGroup = sourceLayout.getGroup();
        Group liveGroup = stagingGroup.getLiveGroup();
        Layout targetLayout = LayoutLocalServiceUtil.getLayout((long)liveGroup.getGroupId(), (boolean)sourceLayout.isPrivateLayout(), (long)sourceLayout.getLayoutId());
        this.copyPortlet(portletRequest, stagingGroup.getGroupId(), liveGroup.getGroupId(), sourceLayout.getPlid(), targetLayout.getPlid(), portlet.getPortletId());
    }

    public void publishToRemote(PortletRequest portletRequest) throws Exception {
        this.publishToRemote(portletRequest, false);
    }

    public void scheduleCopyFromLive(PortletRequest portletRequest) throws Exception {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        Group stagingGroup = GroupLocalServiceUtil.getGroup((long)stagingGroupId);
        long liveGroupId = stagingGroup.getLiveGroupId();
        Map<String, String[]> parameterMap = this.getStagingParameters(portletRequest);
        this.publishLayouts(portletRequest, liveGroupId, stagingGroupId, parameterMap, true);
    }

    public void schedulePublishToLive(PortletRequest portletRequest) throws Exception {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        Group stagingGroup = GroupLocalServiceUtil.getGroup((long)stagingGroupId);
        long liveGroupId = stagingGroup.getLiveGroupId();
        Map<String, String[]> parameterMap = this.getStagingParameters(portletRequest);
        this.publishLayouts(portletRequest, stagingGroupId, liveGroupId, parameterMap, true);
    }

    public void schedulePublishToRemote(PortletRequest portletRequest) throws Exception {
        this.publishToRemote(portletRequest, true);
    }

    public void unscheduleCopyFromLive(PortletRequest portletRequest) throws Exception {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        String jobName = ParamUtil.getString((PortletRequest)portletRequest, (String)"jobName");
        String groupName = this.getSchedulerGroupName("liferay/layouts_local_publisher", stagingGroupId);
        LayoutServiceUtil.unschedulePublishToLive((long)stagingGroupId, (String)jobName, (String)groupName);
    }

    public void unschedulePublishToLive(PortletRequest portletRequest) throws Exception {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        Group stagingGroup = GroupLocalServiceUtil.getGroup((long)stagingGroupId);
        long liveGroupId = stagingGroup.getLiveGroupId();
        String jobName = ParamUtil.getString((PortletRequest)portletRequest, (String)"jobName");
        String groupName = this.getSchedulerGroupName("liferay/layouts_local_publisher", liveGroupId);
        LayoutServiceUtil.unschedulePublishToLive((long)liveGroupId, (String)jobName, (String)groupName);
    }

    public void unschedulePublishToRemote(PortletRequest portletRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId");
        String jobName = ParamUtil.getString((PortletRequest)portletRequest, (String)"jobName");
        String groupName = this.getSchedulerGroupName("liferay/layouts_remote_publisher", groupId);
        LayoutServiceUtil.unschedulePublishToRemote((long)groupId, (String)jobName, (String)groupName);
    }

    public void updateStaging(PortletRequest portletRequest) throws Exception {
        long liveGroupId;
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)(liveGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"liveGroupId")), (String)"MANAGE_STAGING")) {
            throw new PrincipalException();
        }
        int stagingType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"stagingType");
        if (stagingType == 0) {
            this.disableStaging(portletRequest, liveGroupId);
        } else if (stagingType == 1) {
            this.enableLocalStaging(portletRequest, liveGroupId);
        } else if (stagingType == 2) {
            this.enableRemoteStaging(portletRequest, liveGroupId);
        }
    }

    protected void addWeeklyDayPos(PortletRequest portletRequest, List<DayAndPosition> list, int day) {
        if (ParamUtil.getBoolean((PortletRequest)portletRequest, (String)("weeklyDayPos" + day))) {
            list.add(new DayAndPosition(day, 0));
        }
    }

    protected void disableStaging(PortletRequest portletRequest, long liveGroupId) throws Exception {
        Group liveGroup = GroupLocalServiceUtil.getGroup((long)liveGroupId);
        UnicodeProperties typeSettingsProperties = liveGroup.getTypeSettingsProperties();
        typeSettingsProperties.remove((Object)"remoteAddress");
        typeSettingsProperties.remove((Object)"remoteGroupId");
        typeSettingsProperties.remove((Object)"remotePort");
        typeSettingsProperties.remove((Object)"secureConnection");
        typeSettingsProperties.remove((Object)"staged");
        typeSettingsProperties.remove((Object)"stagedRemotely");
        typeSettingsProperties.remove((Object)"workflowEnabled");
        typeSettingsProperties.remove((Object)"workflowRoleNames");
        typeSettingsProperties.remove((Object)"workflowStages");
        HashSet<String> keys = new HashSet<String>();
        for (String key : typeSettingsProperties.keySet()) {
            if (!key.startsWith("staged-portlet_")) continue;
            keys.add(key);
        }
        for (String key : keys) {
            typeSettingsProperties.remove((Object)key);
        }
        if (liveGroup.hasStagingGroup()) {
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
            if (themeDisplay.getScopeGroupId() != liveGroup.getGroupId()) {
                String redirect = ParamUtil.getString((PortletRequest)portletRequest, (String)"pagesRedirect");
                redirect = HttpUtil.removeParameter((String)redirect, (String)"refererPlid");
                redirect = StringUtil.replace((String)redirect, (String)String.valueOf(themeDisplay.getScopeGroupId()), (String)String.valueOf(liveGroup.getGroupId()));
                portletRequest.setAttribute("REDIRECT", (Object)redirect);
            }
            GroupLocalServiceUtil.deleteGroup((long)liveGroup.getStagingGroup().getGroupId());
            TasksProposalLocalServiceUtil.deleteProposals((long)liveGroup.getGroupId());
        }
        GroupLocalServiceUtil.updateGroup((long)liveGroup.getGroupId(), (String)typeSettingsProperties.toString());
    }

    protected void enableLocalStaging(PortletRequest portletRequest, long liveGroupId) throws Exception {
        Group liveGroup = GroupServiceUtil.getGroup((long)liveGroupId);
        if (liveGroup.isStagedRemotely()) {
            this.disableStaging(portletRequest, liveGroupId);
        }
        UnicodeProperties typeSettingsProperties = liveGroup.getTypeSettingsProperties();
        typeSettingsProperties.setProperty("staged", Boolean.TRUE.toString());
        typeSettingsProperties.setProperty("stagedRemotely", String.valueOf(false));
        this.setCommonStagingOptions(portletRequest, liveGroup, typeSettingsProperties);
        if (!liveGroup.hasStagingGroup()) {
            Map<String, String[]> parameterMap;
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAttribute("staging", (Serializable)((Object)String.valueOf(true)));
            Group stagingGroup = GroupLocalServiceUtil.addGroup((long)liveGroup.getCreatorUserId(), (String)liveGroup.getClassName(), (long)liveGroup.getClassPK(), (long)liveGroup.getGroupId(), (String)liveGroup.getDescriptiveName(), (String)liveGroup.getDescription(), (int)liveGroup.getType(), (String)liveGroup.getFriendlyURL(), (boolean)liveGroup.isActive(), (ServiceContext)serviceContext);
            GroupServiceUtil.updateGroup((long)liveGroup.getGroupId(), (String)typeSettingsProperties.toString());
            if (liveGroup.hasPrivateLayouts()) {
                parameterMap = this.getStagingParameters();
                this.publishLayouts(liveGroup.getGroupId(), stagingGroup.getGroupId(), true, parameterMap, null, null);
            }
            if (liveGroup.hasPublicLayouts()) {
                parameterMap = this.getStagingParameters();
                this.publishLayouts(liveGroup.getGroupId(), stagingGroup.getGroupId(), false, parameterMap, null, null);
            }
        } else {
            GroupServiceUtil.updateGroup((long)liveGroup.getGroupId(), (String)typeSettingsProperties.toString());
        }
    }

    protected void enableRemoteStaging(PortletRequest portletRequest, long liveGroupId) throws Exception {
        Group liveGroup = GroupServiceUtil.getGroup((long)liveGroupId);
        String remoteAddress = ParamUtil.getString((PortletRequest)portletRequest, (String)"remoteAddress");
        long remoteGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"remoteGroupId");
        int remotePort = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"remotePort");
        boolean secureConnection = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"secureConnection");
        this.validate(remoteAddress, remoteGroupId, remotePort, secureConnection);
        if (liveGroup.hasStagingGroup()) {
            this.disableStaging(portletRequest, liveGroupId);
        }
        UnicodeProperties typeSettingsProperties = liveGroup.getTypeSettingsProperties();
        typeSettingsProperties.setProperty("remoteAddress", remoteAddress);
        typeSettingsProperties.setProperty("remoteGroupId", String.valueOf(remoteGroupId));
        typeSettingsProperties.setProperty("remotePort", String.valueOf(remotePort));
        typeSettingsProperties.setProperty("secureConnection", String.valueOf(secureConnection));
        typeSettingsProperties.setProperty("staged", Boolean.TRUE.toString());
        typeSettingsProperties.setProperty("stagedRemotely", Boolean.TRUE.toString());
        this.setCommonStagingOptions(portletRequest, liveGroup, typeSettingsProperties);
        GroupServiceUtil.updateGroup((long)liveGroup.getGroupId(), (String)typeSettingsProperties.toString());
    }

    protected String getCronText(PortletRequest portletRequest, Calendar startDate, boolean timeZoneSensitive, int recurrenceType) throws Exception {
        Calendar startCal = null;
        if (timeZoneSensitive) {
            startCal = CalendarFactoryUtil.getCalendar();
            startCal.setTime(startDate.getTime());
        } else {
            startCal = (Calendar)startDate.clone();
        }
        Recurrence recurrence = new Recurrence(startCal, new Duration(1, 0, 0, 0), recurrenceType);
        recurrence.setWeekStart(1);
        if (recurrenceType == 3) {
            int dailyType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"dailyType");
            if (dailyType == 0) {
                int dailyInterval = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"dailyInterval", (int)1);
                recurrence.setInterval(dailyInterval);
            } else {
                DayAndPosition[] dayPos = new DayAndPosition[]{new DayAndPosition(2, 0), new DayAndPosition(3, 0), new DayAndPosition(4, 0), new DayAndPosition(5, 0), new DayAndPosition(6, 0)};
                recurrence.setByDay(dayPos);
            }
        } else if (recurrenceType == 4) {
            int weeklyInterval = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"weeklyInterval", (int)1);
            recurrence.setInterval(weeklyInterval);
            ArrayList<DayAndPosition> dayPos = new ArrayList<DayAndPosition>();
            this.addWeeklyDayPos(portletRequest, dayPos, 1);
            this.addWeeklyDayPos(portletRequest, dayPos, 2);
            this.addWeeklyDayPos(portletRequest, dayPos, 3);
            this.addWeeklyDayPos(portletRequest, dayPos, 4);
            this.addWeeklyDayPos(portletRequest, dayPos, 5);
            this.addWeeklyDayPos(portletRequest, dayPos, 6);
            this.addWeeklyDayPos(portletRequest, dayPos, 7);
            if (dayPos.size() == 0) {
                dayPos.add(new DayAndPosition(2, 0));
            }
            recurrence.setByDay(dayPos.toArray(new DayAndPosition[0]));
        } else if (recurrenceType == 5) {
            int monthlyType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"monthlyType");
            if (monthlyType == 0) {
                int monthlyDay = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"monthlyDay0", (int)1);
                recurrence.setByMonthDay(new int[]{monthlyDay});
                int monthlyInterval = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"monthlyInterval0", (int)1);
                recurrence.setInterval(monthlyInterval);
            } else {
                int monthlyPos = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"monthlyPos");
                int monthlyDay = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"monthlyDay1");
                DayAndPosition[] dayPos = new DayAndPosition[]{new DayAndPosition(monthlyDay, monthlyPos)};
                recurrence.setByDay(dayPos);
                int monthlyInterval = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"monthlyInterval1", (int)1);
                recurrence.setInterval(monthlyInterval);
            }
        } else if (recurrenceType == 6) {
            int yearlyType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyType");
            if (yearlyType == 0) {
                int yearlyMonth = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyMonth0");
                int yearlyDay = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyDay0", (int)1);
                recurrence.setByMonth(new int[]{yearlyMonth});
                recurrence.setByMonthDay(new int[]{yearlyDay});
                int yearlyInterval = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyInterval0", (int)1);
                recurrence.setInterval(yearlyInterval);
            } else {
                int yearlyPos = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyPos");
                int yearlyDay = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyDay1");
                int yearlyMonth = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyMonth1");
                DayAndPosition[] dayPos = new DayAndPosition[]{new DayAndPosition(yearlyDay, yearlyPos)};
                recurrence.setByDay(dayPos);
                recurrence.setByMonth(new int[]{yearlyMonth});
                int yearlyInterval = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyInterval1", (int)1);
                recurrence.setInterval(yearlyInterval);
            }
        }
        return RecurrenceSerializer.toCronText((Recurrence)recurrence);
    }

    protected Calendar getDate(PortletRequest portletRequest, String paramPrefix, boolean timeZoneSensitive) throws Exception {
        int dateMonth = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(paramPrefix) + "Month"));
        int dateDay = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(paramPrefix) + "Day"));
        int dateYear = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(paramPrefix) + "Year"));
        int dateHour = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(paramPrefix) + "Hour"));
        int dateMinute = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(paramPrefix) + "Minute"));
        int dateAmPm = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(paramPrefix) + "AmPm"));
        if (dateAmPm == 1) {
            dateHour += 12;
        }
        Locale locale = null;
        TimeZone timeZone = null;
        if (timeZoneSensitive) {
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
            locale = themeDisplay.getLocale();
            timeZone = themeDisplay.getTimeZone();
        } else {
            locale = LocaleUtil.getDefault();
            timeZone = TimeZoneUtil.getDefault();
        }
        Calendar cal = CalendarFactoryUtil.getCalendar((TimeZone)timeZone, (Locale)locale);
        cal.set(2, dateMonth);
        cal.set(5, dateDay);
        cal.set(1, dateYear);
        cal.set(11, dateHour);
        cal.set(12, dateMinute);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    protected String getWorkflowRoleNames(PortletRequest portletRequest) {
        int workflowStages = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"workflowStages");
        String workflowRoleNames = null;
        if (workflowStages == 0) {
            workflowRoleNames = "";
        } else {
            StringBundler sb = new StringBundler(workflowStages * 2 - 1);
            int i = 1;
            while (i <= workflowStages - 1) {
                if (i > 1) {
                    sb.append(",");
                }
                String workflowRoleName = ParamUtil.getString((PortletRequest)portletRequest, (String)("workflowRoleName_" + i));
                sb.append(workflowRoleName);
                ++i;
            }
            String workflowRoleName = ParamUtil.getString((PortletRequest)portletRequest, (String)"workflowRoleName_Last");
            sb.append(",");
            sb.append(workflowRoleName);
            workflowRoleNames = sb.toString();
        }
        return workflowRoleNames;
    }

    protected void publishLayouts(PortletRequest portletRequest, long sourceGroupId, long targetGroupId, Map<String, String[]> parameterMap, boolean schedule) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        String tabs1 = ParamUtil.getString((PortletRequest)portletRequest, (String)"tabs1");
        boolean privateLayout = true;
        if (tabs1.equals("public-pages")) {
            privateLayout = false;
        }
        String scope = ParamUtil.getString((PortletRequest)portletRequest, (String)"scope");
        LinkedHashMap<Long, Boolean> layoutIdMap = new LinkedHashMap<Long, Boolean>();
        if (scope.equals("selected-pages")) {
            long[] rowIds;
            long[] lArray = rowIds = ParamUtil.getLongValues((PortletRequest)portletRequest, (String)"rowIds");
            int n = rowIds.length;
            int n2 = 0;
            while (n2 < n) {
                long selPlid = lArray[n2];
                boolean includeChildren = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)("includeChildren_" + selPlid));
                layoutIdMap.put(selPlid, includeChildren);
                ++n2;
            }
        }
        String range = ParamUtil.getString((PortletRequest)portletRequest, (String)"range");
        Date startDate = null;
        Date endDate = null;
        if (range.equals("dateRange")) {
            startDate = this.getDate(portletRequest, "startDate", true).getTime();
            endDate = this.getDate(portletRequest, "endDate", true).getTime();
        } else if (range.equals("fromLastPublishDate")) {
            LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)sourceGroupId, (boolean)privateLayout);
            UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
            long lastPublishDate = GetterUtil.getLong((String)settingsProperties.getProperty("last-publish-date"));
            if (lastPublishDate > 0L) {
                Calendar cal = Calendar.getInstance(themeDisplay.getTimeZone(), themeDisplay.getLocale());
                endDate = cal.getTime();
                cal.setTimeInMillis(lastPublishDate);
                startDate = cal.getTime();
            }
        } else if (range.equals("last")) {
            int rangeLast = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"last");
            Date now = new Date();
            startDate = new Date(now.getTime() - (long)rangeLast * 3600000L);
            endDate = now;
        }
        if (schedule) {
            String groupName = this.getSchedulerGroupName("liferay/layouts_local_publisher", targetGroupId);
            int recurrenceType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"recurrenceType");
            Calendar startCal = this.getDate(portletRequest, "schedulerStartDate", true);
            String cronText = this.getCronText(portletRequest, startCal, true, recurrenceType);
            Date schedulerEndDate = null;
            int endDateType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"endDateType");
            if (endDateType == 1) {
                Calendar endCal = this.getDate(portletRequest, "schedulerEndDate", true);
                schedulerEndDate = endCal.getTime();
            }
            String description = ParamUtil.getString((PortletRequest)portletRequest, (String)"description");
            LayoutServiceUtil.schedulePublishToLive((long)sourceGroupId, (long)targetGroupId, (boolean)privateLayout, layoutIdMap, parameterMap, (String)scope, (Date)startDate, (Date)endDate, (String)groupName, (String)cronText, (Date)startCal.getTime(), (Date)schedulerEndDate, (String)description);
        } else {
            MessageStatus messageStatus = new MessageStatus();
            messageStatus.startTimer();
            String command = "SELECTED_PAGES";
            try {
                try {
                    if (scope.equals("all-pages")) {
                        command = "ALL_PAGES";
                        this.publishLayouts(sourceGroupId, targetGroupId, privateLayout, parameterMap, startDate, endDate);
                    } else {
                        this.publishLayouts(sourceGroupId, targetGroupId, privateLayout, layoutIdMap, parameterMap, startDate, endDate);
                    }
                }
                catch (Exception e) {
                    messageStatus.setException(e);
                    throw e;
                }
            }
            finally {
                messageStatus.stopTimer();
                LayoutsLocalPublisherRequest publisherRequest = new LayoutsLocalPublisherRequest(command, themeDisplay.getUserId(), sourceGroupId, targetGroupId, privateLayout, layoutIdMap, parameterMap, startDate, endDate);
                messageStatus.setPayload((Object)publisherRequest);
                MessageBusUtil.sendMessage((String)"liferay/message_bus/message_status", (Object)messageStatus);
            }
        }
    }

    protected void publishToRemote(PortletRequest portletRequest, boolean schedule) throws Exception {
        String scope;
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        String tabs1 = ParamUtil.getString((PortletRequest)portletRequest, (String)"tabs1");
        long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId");
        boolean privateLayout = true;
        if (tabs1.equals("public-pages")) {
            privateLayout = false;
        }
        if (Validator.isNull((String)(scope = ParamUtil.getString((PortletRequest)portletRequest, (String)"scope")))) {
            scope = "all-pages";
        }
        LinkedHashMap<Long, Boolean> layoutIdMap = null;
        Map parameterMap = portletRequest.getParameterMap();
        if (scope.equals("selected-pages")) {
            long[] rowIds;
            layoutIdMap = new LinkedHashMap<Long, Boolean>();
            long[] lArray = rowIds = ParamUtil.getLongValues((PortletRequest)portletRequest, (String)"rowIds");
            int n = rowIds.length;
            int n2 = 0;
            while (n2 < n) {
                long selPlid = lArray[n2];
                boolean includeChildren = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)("includeChildren_" + selPlid));
                layoutIdMap.put(selPlid, includeChildren);
                ++n2;
            }
        }
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        UnicodeProperties groupTypeSettingsProperties = group.getTypeSettingsProperties();
        String remoteAddress = ParamUtil.getString((PortletRequest)portletRequest, (String)"remoteAddress", (String)groupTypeSettingsProperties.getProperty("remoteAddress"));
        long remoteGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"remoteGroupId", (long)GetterUtil.getLong((String)groupTypeSettingsProperties.getProperty("remoteGroupId")));
        int remotePort = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"remotePort", (int)GetterUtil.getInteger((String)groupTypeSettingsProperties.getProperty("remotePort")));
        boolean remotePrivateLayout = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"remotePrivateLayout");
        boolean secureConnection = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"secureConnection", (boolean)GetterUtil.getBoolean((String)groupTypeSettingsProperties.getProperty("secureConnection")));
        this.validate(remoteAddress, remoteGroupId, remotePort, secureConnection);
        String range = ParamUtil.getString((PortletRequest)portletRequest, (String)"range");
        Date startDate = null;
        Date endDate = null;
        if (range.equals("dateRange")) {
            startDate = this.getDate(portletRequest, "startDate", true).getTime();
            endDate = this.getDate(portletRequest, "endDate", true).getTime();
        } else if (range.equals("fromLastPublishDate")) {
            LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
            UnicodeProperties layoutTypeSettingsProperties = layoutSet.getSettingsProperties();
            long lastPublishDate = GetterUtil.getLong((String)layoutTypeSettingsProperties.getProperty("last-publish-date"));
            if (lastPublishDate > 0L) {
                Calendar cal = Calendar.getInstance(themeDisplay.getTimeZone(), themeDisplay.getLocale());
                endDate = cal.getTime();
                cal.setTimeInMillis(lastPublishDate);
                startDate = cal.getTime();
            }
        } else if (range.equals("last")) {
            int rangeLast = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"last");
            Date now = new Date();
            startDate = new Date(now.getTime() - (long)rangeLast * 3600000L);
            endDate = now;
        }
        if (schedule) {
            String groupName = this.getSchedulerGroupName("liferay/layouts_remote_publisher", groupId);
            int recurrenceType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"recurrenceType");
            Calendar startCal = this.getDate(portletRequest, "schedulerStartDate", true);
            String cronText = this.getCronText(portletRequest, startCal, true, recurrenceType);
            Date schedulerEndDate = null;
            int endDateType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"endDateType");
            if (endDateType == 1) {
                Calendar endCal = this.getDate(portletRequest, "schedulerEndDate", true);
                schedulerEndDate = endCal.getTime();
            }
            String description = ParamUtil.getString((PortletRequest)portletRequest, (String)"description");
            LayoutServiceUtil.schedulePublishToRemote((long)groupId, (boolean)privateLayout, layoutIdMap, this.getStagingParameters(portletRequest), (String)remoteAddress, (int)remotePort, (boolean)secureConnection, (long)remoteGroupId, (boolean)remotePrivateLayout, (Date)startDate, (Date)endDate, (String)groupName, (String)cronText, (Date)startCal.getTime(), (Date)schedulerEndDate, (String)description);
        } else {
            MessageStatus messageStatus = new MessageStatus();
            messageStatus.startTimer();
            try {
                try {
                    this.copyRemoteLayouts(groupId, privateLayout, layoutIdMap, parameterMap, remoteAddress, remotePort, secureConnection, remoteGroupId, remotePrivateLayout, this.getStagingParameters(portletRequest), startDate, endDate);
                }
                catch (Exception e) {
                    messageStatus.setException(e);
                    throw e;
                }
            }
            finally {
                messageStatus.stopTimer();
                LayoutsRemotePublisherRequest publisherRequest = new LayoutsRemotePublisherRequest(themeDisplay.getUserId(), groupId, privateLayout, layoutIdMap, parameterMap, remoteAddress, remotePort, secureConnection, remoteGroupId, remotePrivateLayout, startDate, endDate);
                messageStatus.setPayload((Object)publisherRequest);
                MessageBusUtil.sendMessage((String)"liferay/message_bus/message_status", (Object)messageStatus);
            }
        }
    }

    protected void setCommonStagingOptions(PortletRequest portletRequest, Group liveGroup, UnicodeProperties typeSettingsProperties) throws Exception {
        LayoutExporter.updateLastPublishDate(liveGroup.getPrivateLayoutSet(), 0L);
        LayoutExporter.updateLastPublishDate(liveGroup.getPublicLayoutSet(), 0L);
        Enumeration enu = portletRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String parameterName = (String)enu.nextElement();
            boolean staged = MapUtil.getBoolean((Map)portletRequest.getParameterMap(), (String)parameterName);
            if (!parameterName.startsWith("staged-portlet_") || parameterName.endsWith("Checkbox")) continue;
            typeSettingsProperties.setProperty(parameterName, String.valueOf(staged));
        }
        boolean workflowEnabled = false;
        int workflowStages = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"workflowStages");
        if (workflowStages > 1) {
            workflowEnabled = true;
        }
        typeSettingsProperties.setProperty("workflowEnabled", String.valueOf(workflowEnabled));
        if (workflowEnabled) {
            String workflowRoleNames = this.getWorkflowRoleNames(portletRequest);
            if (Validator.isNull((String)workflowRoleNames)) {
                workflowRoleNames = PropsValues.TASKS_DEFAULT_ROLE_NAMES;
            }
            typeSettingsProperties.setProperty("workflowRoleNames", workflowRoleNames);
            if (workflowStages < PropsValues.TASKS_DEFAULT_STAGES) {
                workflowStages = PropsValues.TASKS_DEFAULT_STAGES;
            }
            typeSettingsProperties.setProperty("workflowStages", String.valueOf(workflowStages));
        }
    }

    protected void validate(String remoteAddress, long remoteGroupId, int remotePort, boolean secureConnection) throws Exception {
        RemoteOptionsException roe = null;
        if (!Validator.isDomain((String)remoteAddress) && !Validator.isIPAddress((String)remoteAddress)) {
            roe = new RemoteOptionsException(1);
            roe.setRemoteAddress(remoteAddress);
            throw roe;
        }
        if (remotePort < 1 || remotePort > 65535) {
            roe = new RemoteOptionsException(2);
            roe.setRemotePort(remotePort);
            throw roe;
        }
        if (remoteGroupId <= 0L) {
            roe = new RemoteOptionsException(3);
            roe.setRemoteGroupId(remoteGroupId);
            throw roe;
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = UserLocalServiceUtil.getUser((long)permissionChecker.getUserId());
        StringBundler sb = new StringBundler(4);
        if (secureConnection) {
            sb.append("https://");
        } else {
            sb.append("http://");
        }
        sb.append(remoteAddress);
        sb.append(":");
        sb.append(remotePort);
        String url = sb.toString();
        HttpPrincipal httpPrincipal = new HttpPrincipal(url, user.getEmailAddress(), user.getPassword(), user.getPasswordEncrypted());
        try {
            GroupServiceHttp.getGroup(httpPrincipal, remoteGroupId);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            RemoteExportException ree = new RemoteExportException(2);
            ree.setGroupId(remoteGroupId);
            throw ree;
        }
        catch (SystemException systemException) {
            RemoteExportException ree = new RemoteExportException(1);
            ree.setURL(url);
            throw ree;
        }
    }
}

