/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.context;

import com.liferay.portal.bean.BeanLocatorImpl;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.spring.context.PortletContextLoader;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class PortletContextLoaderListener
extends ContextLoaderListener {
    private static Log _log = LogFactoryUtil.getLog(PortletContextLoaderListener.class);

    public void contextDestroyed(ServletContextEvent event) {
        block2: {
            ClassLoader classLoader = PortletClassLoaderUtil.getClassLoader();
            ServletContext servletContext = event.getServletContext();
            try {
                Class<?> beanLocatorUtilClass = Class.forName("com.liferay.util.bean.PortletBeanLocatorUtil", true, classLoader);
                Method setBeanLocatorMethod = beanLocatorUtilClass.getMethod("setBeanLocator", BeanLocator.class);
                setBeanLocatorMethod.invoke(beanLocatorUtilClass, new Object[1]);
                PortletBeanLocatorUtil.setBeanLocator((String)servletContext.getServletContextName(), null);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        super.contextDestroyed(event);
    }

    public void contextInitialized(ServletContextEvent event) {
        super.contextInitialized(event);
        ClassLoader classLoader = PortletClassLoaderUtil.getClassLoader();
        ServletContext servletContext = event.getServletContext();
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        BeanLocatorImpl beanLocator = new BeanLocatorImpl(classLoader, (ApplicationContext)applicationContext);
        try {
            Class<?> beanLocatorUtilClass = Class.forName("com.liferay.util.bean.PortletBeanLocatorUtil", true, classLoader);
            Method setBeanLocatorMethod = beanLocatorUtilClass.getMethod("setBeanLocator", BeanLocator.class);
            setBeanLocatorMethod.invoke(beanLocatorUtilClass, beanLocator);
            PortletBeanLocatorUtil.setBeanLocator((String)servletContext.getServletContextName(), (BeanLocator)beanLocator);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        servletContext.removeAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
    }

    protected ContextLoader createContextLoader() {
        return new PortletContextLoader();
    }
}

