/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.context;

import com.liferay.portal.bean.BeanLocatorImpl;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.cache.ThreadLocalCacheManager;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.util.ClearThreadLocalUtil;
import com.liferay.portal.kernel.util.ClearTimerThreadUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.util.InitUtil;
import javax.servlet.ServletContextEvent;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public class PortalContextLoaderListener
extends ContextLoaderListener {
    private Log _log = LogFactoryUtil.getLog(PortalContextLoaderListener.class);

    public void contextInitialized(ServletContextEvent event) {
        InitUtil.init();
        super.contextInitialized(event);
        WebApplicationContext applicationContext = ContextLoader.getCurrentWebApplicationContext();
        ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
        BeanLocatorImpl beanLocator = new BeanLocatorImpl(portalClassLoader, (ApplicationContext)applicationContext);
        PortalBeanLocatorUtil.setBeanLocator((BeanLocator)beanLocator);
        ClassLoader classLoader = portalClassLoader;
        while (classLoader != null) {
            CachedIntrospectionResults.clearClassLoader((ClassLoader)classLoader);
            classLoader = classLoader.getParent();
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        super.contextDestroyed(event);
        HotDeployUtil.reset();
        InstancePool.reset();
        PortletBagPool.reset();
        ThreadLocalCacheManager.destroy();
        try {
            ClearThreadLocalUtil.clearThreadLocal();
        }
        catch (Exception e) {
            this._log.error((Object)e, (Throwable)e);
        }
        try {
            ClearTimerThreadUtil.clearTimerThread();
        }
        catch (Exception e) {
            this._log.error((Object)e, (Throwable)e);
        }
    }
}

