/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.gzip;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncPrintWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.servlet.filters.gzip.GZipServletOutputStream;
import com.liferay.util.RSSThreadLocal;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class GZipResponse
extends HttpServletResponseWrapper {
    private static final String _GZIP = "gzip";
    private static final Log _log = LogFactoryUtil.getLog(GZipResponse.class);
    private boolean _firefox;
    private PrintWriter _printWriter;
    private HttpServletResponse _response;
    private ServletOutputStream _servletOutputStream;
    private UnsyncByteArrayOutputStream _unsyncByteArrayOutputStream;

    public GZipResponse(HttpServletRequest request, HttpServletResponse response) {
        super(response);
        this._response = response;
        this._response.setContentLength(-1);
        this._response.addHeader("Content-Encoding", _GZIP);
        this._firefox = BrowserSnifferUtil.isFirefox((HttpServletRequest)request);
    }

    public void finishResponse() throws IOException {
        try {
            if (this._printWriter != null) {
                this._printWriter.close();
            } else if (this._servletOutputStream != null) {
                this._servletOutputStream.close();
            }
        }
        catch (IOException iOException) {}
        if (this._unsyncByteArrayOutputStream != null) {
            this._response.setContentLength(this._unsyncByteArrayOutputStream.size());
            this._unsyncByteArrayOutputStream.writeTo((OutputStream)this._response.getOutputStream());
        }
    }

    public void flushBuffer() throws IOException {
        if (this._servletOutputStream != null) {
            this._servletOutputStream.flush();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._printWriter != null) {
            throw new IllegalStateException();
        }
        if (this._servletOutputStream == null) {
            if (this._firefox && RSSThreadLocal.isExportRSS()) {
                this._unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                this._servletOutputStream = new GZipServletOutputStream((OutputStream)this._unsyncByteArrayOutputStream);
            } else {
                this._servletOutputStream = new GZipServletOutputStream((OutputStream)this._response.getOutputStream());
            }
        }
        return this._servletOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this._printWriter != null) {
            return this._printWriter;
        }
        if (this._servletOutputStream != null) {
            throw new IllegalStateException();
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Use getOutputStream for optimum performance");
        }
        this._servletOutputStream = this.getOutputStream();
        this._printWriter = new UnsyncPrintWriter((Writer)new OutputStreamWriter((OutputStream)this._servletOutputStream, "UTF-8"));
        return this._printWriter;
    }

    public void setContentLength(int contentLength) {
    }
}

