/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.fragment;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.StringServletResponse;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.util.servlet.ServletResponseUtil;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FragmentFilter
extends BasePortalFilter {
    public static final String SKIP_FILTER = String.valueOf(FragmentFilter.class.getName()) + "SKIP_FILTER";
    private static Log _log = LogFactoryUtil.getLog(FragmentFilter.class);

    protected String getContent(HttpServletRequest request, String content) {
        String fragmentId = ParamUtil.getString((HttpServletRequest)request, (String)"p_f_id");
        int x = content.indexOf("<!-- Begin fragment " + fragmentId + " -->");
        int y = content.indexOf("<!-- End fragment " + fragmentId + " -->");
        if (x == -1 || y == -1) {
            return content;
        }
        x = content.indexOf(">", x);
        return content.substring(x + 1, y);
    }

    protected boolean isAlreadyFiltered(HttpServletRequest request) {
        return request.getAttribute(SKIP_FILTER) != null;
    }

    protected boolean isFragment(HttpServletRequest request, HttpServletResponse response) {
        String fragmentId = ParamUtil.getString((HttpServletRequest)request, (String)"p_f_id");
        return Validator.isNotNull((String)fragmentId);
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        if (this.isFragment(request, response) && !this.isAlreadyFiltered(request)) {
            request.setAttribute(SKIP_FILTER, (Object)Boolean.TRUE);
            if (_log.isDebugEnabled()) {
                String completeURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
                _log.debug((Object)("Fragmenting " + completeURL));
            }
            StringServletResponse stringServerResponse = new StringServletResponse(response);
            this.processFilter(FragmentFilter.class, request, (HttpServletResponse)stringServerResponse, filterChain);
            String content = this.getContent(request, stringServerResponse.getString());
            ServletResponseUtil.write((HttpServletResponse)response, (String)content);
        } else {
            if (_log.isDebugEnabled()) {
                String completeURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
                _log.debug((Object)("Not fragmenting " + completeURL));
            }
            this.processFilter(FragmentFilter.class, request, response, filterChain);
        }
    }
}

