/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.cache;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.servlet.filters.CacheResponseData;
import java.io.Serializable;

public class CacheUtil {
    public static String CACHE_NAME = CacheUtil.class.getName();
    private static PortalCache _portalCache = MultiVMPoolUtil.getCache((String)CACHE_NAME);

    public static void clearCache() {
        _portalCache.removeAll();
    }

    public static void clearCache(long companyId) {
        CacheUtil.clearCache();
    }

    public static CacheResponseData getCacheResponseData(long companyId, String key) {
        if (Validator.isNull((String)key)) {
            return null;
        }
        key = CacheUtil._encodeKey(companyId, key);
        CacheResponseData data = (CacheResponseData)_portalCache.get(key);
        return data;
    }

    public static void putCacheResponseData(long companyId, String key, CacheResponseData data) {
        if (data != null) {
            key = CacheUtil._encodeKey(companyId, key);
            _portalCache.put(key, (Serializable)data);
        }
    }

    private static String _encodeKey(long companyId, String key) {
        StringBundler sb = new StringBundler(5);
        sb.append(CACHE_NAME);
        sb.append("#");
        sb.append(companyId);
        sb.append("#");
        sb.append(key);
        return sb.toString();
    }
}

