/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedSessionAttributeCache
implements Serializable {
    private static final String _SESSION_KEY = SharedSessionAttributeCache.class.getName();
    private Map<String, Object> _attributes = new ConcurrentHashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SharedSessionAttributeCache getInstance(HttpSession session) {
        HttpSession httpSession = session;
        synchronized (httpSession) {
            SharedSessionAttributeCache cache = (SharedSessionAttributeCache)session.getAttribute(_SESSION_KEY);
            if (cache == null) {
                cache = new SharedSessionAttributeCache();
                session.setAttribute(_SESSION_KEY, (Object)cache);
            }
            return cache;
        }
    }

    public boolean contains(String name) {
        return this._attributes.containsKey(name);
    }

    public Map<String, Object> getValues() {
        return this._attributes;
    }

    public void removeAttribute(String key) {
        this._attributes.remove(key);
    }

    public void setAttribute(String key, Object value) {
        this._attributes.put(key, value);
    }

    private SharedSessionAttributeCache() {
    }
}

