/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence;

import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.util.InitialThreadLocal;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.persistence.BatchSession;
import com.liferay.portal.util.PropsValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchSessionImpl
implements BatchSession {
    private static final long _INITIAL_COUNTER = 1L;
    private static ThreadLocal<Long> _counter = new InitialThreadLocal(BatchSessionImpl.class + "._counter", (Object)1L);
    private static ThreadLocal<Boolean> _enabled = new InitialThreadLocal(BatchSessionImpl.class + "._enabled", (Object)false);

    public void delete(Session session, BaseModel<?> model) throws ORMException {
        Object staleObject;
        if ((model.isCachedModel() || this.isEnabled()) && (staleObject = session.get(model.getClass(), model.getPrimaryKeyObj())) != null) {
            session.evict(staleObject);
        }
        session.delete(model);
        if (!this.isEnabled()) {
            session.flush();
            return;
        }
        if (PropsValues.HIBERNATE_JDBC_BATCH_SIZE == 0 || _counter.get() % (long)PropsValues.HIBERNATE_JDBC_BATCH_SIZE == 0L) {
            session.flush();
        }
        _counter.set(_counter.get() + 1L);
    }

    public boolean isEnabled() {
        return _enabled.get();
    }

    public void setEnabled(boolean enabled) {
        _enabled.set(enabled);
    }

    public void update(Session session, BaseModel<?> model, boolean merge) throws ORMException {
        if (merge || model.isCachedModel()) {
            session.merge(model);
        } else if (model.isNew()) {
            session.save(model);
        } else {
            Object obj;
            boolean contains = false;
            if (this.isEnabled() && (obj = session.get(model.getClass(), model.getPrimaryKeyObj())) != null && obj.equals(model)) {
                contains = true;
            }
            if (!contains && !session.contains(model)) {
                session.saveOrUpdate(model);
            }
        }
        if (!this.isEnabled()) {
            session.flush();
            return;
        }
        if (PropsValues.HIBERNATE_JDBC_BATCH_SIZE == 0 || _counter.get() % (long)PropsValues.HIBERNATE_JDBC_BATCH_SIZE == 0L) {
            session.flush();
        }
        _counter.set(_counter.get() + 1L);
    }
}

