/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.service.permission.UserPermission;
import com.liferay.portal.util.PropsValues;

public class UserPermissionImpl
implements UserPermission {
    private static Log _log = LogFactoryUtil.getLog(UserPermissionImpl.class);

    public void check(PermissionChecker permissionChecker, long userId, long organizationId, long locationId, String actionId) throws PrincipalException {
        this.check(permissionChecker, userId, new long[]{organizationId, locationId}, actionId);
    }

    public void check(PermissionChecker permissionChecker, long userId, long[] organizationIds, String actionId) throws PrincipalException {
        if (!this.contains(permissionChecker, userId, organizationIds, actionId)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, long userId, String actionId) throws PrincipalException {
        if (!this.contains(permissionChecker, userId, actionId)) {
            throw new PrincipalException();
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long userId, long organizationId, long locationId, String actionId) {
        return this.contains(permissionChecker, userId, new long[]{organizationId, locationId}, actionId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(PermissionChecker permissionChecker, long userId, long[] organizationIds, String actionId) {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5 || PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), User.class.getName(), userId, userId, actionId)) return true;
        }
        if (permissionChecker.getUserId() == userId) {
            return true;
        }
        if (permissionChecker.hasPermission(0L, User.class.getName(), userId, actionId)) {
            return true;
        }
        if (userId == -1L) return false;
        try {
            if (organizationIds == null) {
                User user = UserLocalServiceUtil.getUserById((long)userId);
                organizationIds = user.getOrganizationIds();
            }
            int i = 0;
            while (true) {
                if (i >= organizationIds.length) {
                    return false;
                }
                long organizationId = organizationIds[i];
                if (OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)organizationId, (String)"MANAGE_USERS")) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return false;
    }

    public boolean contains(PermissionChecker permissionChecker, long userId, String actionId) {
        return this.contains(permissionChecker, userId, null, actionId);
    }
}

