/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchWorkflowInstanceLinkException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManagerUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.model.WorkflowDefinitionLink;
import com.liferay.portal.model.WorkflowInstanceLink;
import com.liferay.portal.service.base.WorkflowInstanceLinkLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowInstanceLinkLocalServiceImpl
extends WorkflowInstanceLinkLocalServiceBaseImpl {
    public WorkflowInstanceLink addWorkflowInstanceLink(long userId, long companyId, long groupId, String className, long classPK, long workflowInstanceId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        Date now = new Date();
        long workflowInstanceLinkId = this.counterLocalService.increment();
        WorkflowInstanceLink workflowInstanceLink = this.workflowInstanceLinkPersistence.create(workflowInstanceLinkId);
        workflowInstanceLink.setCreateDate(now);
        workflowInstanceLink.setModifiedDate(now);
        workflowInstanceLink.setUserId(userId);
        workflowInstanceLink.setUserName(user.getFullName());
        workflowInstanceLink.setGroupId(groupId);
        workflowInstanceLink.setCompanyId(companyId);
        workflowInstanceLink.setClassNameId(classNameId);
        workflowInstanceLink.setClassPK(classPK);
        workflowInstanceLink.setWorkflowInstanceId(workflowInstanceId);
        this.workflowInstanceLinkPersistence.update((BaseModel)workflowInstanceLink, false);
        return workflowInstanceLink;
    }

    public void deleteWorkflowInstanceLink(long companyId, long groupId, String className, long classPK) throws PortalException, SystemException {
        try {
            WorkflowInstanceLink workflowInstanceLink = this.getWorkflowInstanceLink(companyId, groupId, className, classPK);
            this.deleteWorkflowInstanceLink(workflowInstanceLink);
            WorkflowInstanceManagerUtil.deleteWorkflowInstance((long)companyId, (long)workflowInstanceLink.getWorkflowInstanceId());
        }
        catch (NoSuchWorkflowInstanceLinkException noSuchWorkflowInstanceLinkException) {}
    }

    public void deleteWorkflowInstanceLinks(long companyId, long groupId, String className, long classPK) throws PortalException, SystemException {
        List<WorkflowInstanceLink> workflowInstanceLinks = this.getWorkflowInstanceLinks(companyId, groupId, className, classPK);
        for (WorkflowInstanceLink workflowInstanceLink : workflowInstanceLinks) {
            this.deleteWorkflowInstanceLink(workflowInstanceLink);
            WorkflowInstanceManagerUtil.deleteWorkflowInstance((long)companyId, (long)workflowInstanceLink.getWorkflowInstanceId());
        }
    }

    public String getState(long companyId, long groupId, String className, long classPK) throws PortalException, SystemException {
        WorkflowInstanceLink workflowInstanceLink = this.getWorkflowInstanceLink(companyId, groupId, className, classPK);
        WorkflowInstance workflowInstance = WorkflowInstanceManagerUtil.getWorkflowInstance((long)companyId, (long)workflowInstanceLink.getWorkflowInstanceId());
        return workflowInstance.getState();
    }

    public WorkflowInstanceLink getWorkflowInstanceLink(long companyId, long groupId, String className, long classPK) throws PortalException, SystemException {
        List<WorkflowInstanceLink> workflowInstanceLinks = this.getWorkflowInstanceLinks(companyId, groupId, className, classPK);
        if (workflowInstanceLinks.isEmpty()) {
            throw new NoSuchWorkflowInstanceLinkException();
        }
        return workflowInstanceLinks.get(0);
    }

    public List<WorkflowInstanceLink> getWorkflowInstanceLinks(long companyId, long groupId, String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.workflowInstanceLinkPersistence.findByG_C_C_C(groupId, companyId, classNameId, classPK);
    }

    public boolean hasWorkflowInstanceLink(long companyId, long groupId, String className, long classPK) throws PortalException, SystemException {
        try {
            this.getWorkflowInstanceLink(companyId, groupId, className, classPK);
            return true;
        }
        catch (NoSuchWorkflowInstanceLinkException noSuchWorkflowInstanceLinkException) {
            return false;
        }
    }

    public boolean isEnded(long companyId, long groupId, String className, long classPK) throws PortalException, SystemException {
        try {
            WorkflowInstanceLink workflowInstanceLink = this.getWorkflowInstanceLink(companyId, groupId, className, classPK);
            WorkflowInstance workflowInstance = WorkflowInstanceManagerUtil.getWorkflowInstance((long)companyId, (long)workflowInstanceLink.getWorkflowInstanceId());
            if (workflowInstance.getEndDate() != null) {
                return true;
            }
        }
        catch (NoSuchWorkflowInstanceLinkException noSuchWorkflowInstanceLinkException) {}
        return false;
    }

    public void startWorkflowInstance(long companyId, long groupId, long userId, String className, long classPK, Map<String, Serializable> workflowContext) throws PortalException, SystemException {
        if (!WorkflowThreadLocal.isEnabled()) {
            return;
        }
        WorkflowDefinitionLink workflowDefinitionLink = this.workflowDefinitionLinkLocalService.getWorkflowDefinitionLink(companyId, groupId, className);
        String workflowDefinitionName = workflowDefinitionLink.getWorkflowDefinitionName();
        int workflowDefinitionVersion = workflowDefinitionLink.getWorkflowDefinitionVersion();
        workflowContext = workflowContext != null ? new HashMap<String, Serializable>(workflowContext) : new HashMap<String, Serializable>();
        workflowContext.put("companyId", (Serializable)((Object)String.valueOf(companyId)));
        workflowContext.put("groupId", (Serializable)((Object)String.valueOf(groupId)));
        workflowContext.put("entryClassName", (Serializable)((Object)className));
        workflowContext.put("entryClassPK", (Serializable)((Object)String.valueOf(classPK)));
        WorkflowHandler workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler((String)className);
        workflowContext.put("entryType", (Serializable)((Object)workflowHandler.getType(LocaleUtil.getDefault())));
        WorkflowInstance workflowInstance = WorkflowInstanceManagerUtil.startWorkflowInstance((long)companyId, (long)groupId, (long)userId, (String)workflowDefinitionName, (Integer)workflowDefinitionVersion, null, workflowContext);
        this.addWorkflowInstanceLink(userId, companyId, groupId, className, classPK, workflowInstance.getWorkflowInstanceId());
    }

    public void updateClassPK(long companyId, long groupId, String className, long oldClassPK, long newClassPK) throws PortalException, SystemException {
        if (!WorkflowThreadLocal.isEnabled()) {
            return;
        }
        List<WorkflowInstanceLink> workflowInstanceLinks = this.getWorkflowInstanceLinks(companyId, groupId, className, oldClassPK);
        for (WorkflowInstanceLink workflowInstanceLink : workflowInstanceLinks) {
            WorkflowInstance workflowInstance = WorkflowInstanceManagerUtil.getWorkflowInstance((long)workflowInstanceLink.getCompanyId(), (long)workflowInstanceLink.getWorkflowInstanceId());
            workflowInstanceLink.setClassPK(newClassPK);
            this.workflowInstanceLinkPersistence.update((BaseModel)workflowInstanceLink, false);
            HashMap<String, String> workflowContext = new HashMap<String, String>(workflowInstance.getWorkflowContext());
            workflowContext.put("entryClassPK", String.valueOf(newClassPK));
            WorkflowInstanceManagerUtil.updateWorkflowContext((long)workflowInstanceLink.getCompanyId(), (long)workflowInstanceLink.getWorkflowInstanceId(), workflowContext);
        }
    }
}

