/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.base.RoleServiceBaseImpl;
import com.liferay.portal.service.permission.PortalPermissionUtil;
import com.liferay.portal.service.permission.RolePermissionUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleServiceImpl
extends RoleServiceBaseImpl {
    public Role addRole(String name, Map<Locale, String> titleMap, String description, int type) throws PortalException, SystemException {
        User user = this.getUser();
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_ROLE");
        return this.roleLocalService.addRole(user.getUserId(), user.getCompanyId(), name, titleMap, description, type);
    }

    public void addUserRoles(long userId, long[] roleIds) throws PortalException, SystemException {
        this.checkUserRolesPermission(userId, roleIds);
        this.roleLocalService.addUserRoles(userId, roleIds);
    }

    public void deleteRole(long roleId) throws PortalException, SystemException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"DELETE");
        this.roleLocalService.deleteRole(roleId);
    }

    public List<Role> getGroupRoles(long groupId) throws SystemException {
        return this.roleLocalService.getGroupRoles(groupId);
    }

    public Role getRole(long roleId) throws PortalException, SystemException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"VIEW");
        return this.roleLocalService.getRole(roleId);
    }

    public Role getRole(long companyId, String name) throws PortalException, SystemException {
        Role role = this.roleLocalService.getRole(companyId, name);
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)role.getRoleId(), (String)"VIEW");
        return role;
    }

    public List<Role> getUserGroupGroupRoles(long userId, long groupId) throws SystemException {
        return this.roleLocalService.getUserGroupGroupRoles(userId, groupId);
    }

    public List<Role> getUserGroupRoles(long userId, long groupId) throws SystemException {
        return this.roleLocalService.getUserGroupRoles(userId, groupId);
    }

    public List<Role> getUserRelatedRoles(long userId, List<Group> groups) throws SystemException {
        return this.roleLocalService.getUserRelatedRoles(userId, groups);
    }

    public List<Role> getUserRoles(long userId) throws SystemException {
        return this.roleLocalService.getUserRoles(userId);
    }

    public boolean hasUserRole(long userId, long companyId, String name, boolean inherited) throws PortalException, SystemException {
        return this.roleLocalService.hasUserRole(userId, companyId, name, inherited);
    }

    public boolean hasUserRoles(long userId, long companyId, String[] names, boolean inherited) throws PortalException, SystemException {
        return this.roleLocalService.hasUserRoles(userId, companyId, names, inherited);
    }

    public void unsetUserRoles(long userId, long[] roleIds) throws PortalException, SystemException {
        this.checkUserRolesPermission(userId, roleIds);
        this.roleLocalService.unsetUserRoles(userId, roleIds);
    }

    public Role updateRole(long roleId, String name, Map<Locale, String> titleMap, String description, String subtype) throws PortalException, SystemException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"UPDATE");
        return this.roleLocalService.updateRole(roleId, name, titleMap, description, subtype);
    }

    protected void checkUserRolesPermission(long userId, long[] roleIds) throws PortalException {
        int i = 0;
        while (i < roleIds.length) {
            RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleIds[i], (String)"ASSIGN_MEMBERS");
            ++i;
        }
    }
}

