/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.DuplicateRoleException;
import com.liferay.portal.NoSuchRoleException;
import com.liferay.portal.RequiredRoleException;
import com.liferay.portal.RoleNameException;
import com.liferay.portal.kernel.annotation.Propagation;
import com.liferay.portal.kernel.annotation.Transactional;
import com.liferay.portal.kernel.cache.ThreadLocalCachable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Team;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.base.RoleLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.enterpriseadmin.util.EnterpriseAdminUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleLocalServiceImpl
extends RoleLocalServiceBaseImpl {
    private Map<String, Role> _systemRolesMap = new HashMap<String, Role>();

    public Role addRole(long userId, long companyId, String name, Map<Locale, String> titleMap, String description, int type) throws PortalException, SystemException {
        return this.addRole(userId, companyId, name, titleMap, description, type, null, 0L);
    }

    public Role addRole(long userId, long companyId, String name, Map<Locale, String> titleMap, String description, int type, String className, long classPK) throws PortalException, SystemException {
        className = GetterUtil.getString((String)className);
        long classNameId = PortalUtil.getClassNameId((String)className);
        long roleId = this.counterLocalService.increment();
        if (classNameId <= 0L || className.equals(Role.class.getName())) {
            classNameId = PortalUtil.getClassNameId(Role.class);
            classPK = roleId;
        }
        this.validate(0L, companyId, classNameId, name);
        Role role = this.rolePersistence.create(roleId);
        role.setCompanyId(companyId);
        role.setClassNameId(classNameId);
        role.setClassPK(classPK);
        role.setName(name);
        role.setTitleMap(titleMap);
        role.setDescription(description);
        role.setType(type);
        this.rolePersistence.update((BaseModel)role, false);
        if (userId > 0L) {
            this.resourceLocalService.addResources(companyId, 0L, userId, Role.class.getName(), role.getRoleId(), false, false, false);
            Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
            indexer.reindex((Object)userId);
        }
        return role;
    }

    public void addUserRoles(long userId, long[] roleIds) throws PortalException, SystemException {
        this.userPersistence.addRoles(userId, roleIds);
        Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
        indexer.reindex((Object)userId);
        PermissionCacheUtil.clearCache();
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkSystemRoles(long companyId) throws PortalException, SystemException {
        String[] systemOrganizationRoles;
        String[] systemCommunityRoles;
        String[] systemRoles;
        for (Role role : this.roleFinder.findBySystem(companyId)) {
            this._systemRolesMap.put(String.valueOf(companyId) + role.getName(), role);
        }
        String[] stringArray = systemRoles = PortalUtil.getSystemRoles();
        int n = systemRoles.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            String description = PropsUtil.get("system.role." + StringUtil.replace((String)name, (String)" ", (String)".") + ".description");
            int type = 1;
            this.checkSystemRole(companyId, name, description, type);
            ++n2;
        }
        String[] stringArray2 = systemCommunityRoles = PortalUtil.getSystemCommunityRoles();
        int n3 = systemCommunityRoles.length;
        n = 0;
        while (n < n3) {
            String name = stringArray2[n];
            String description = PropsUtil.get("system.community.role." + StringUtil.replace((String)name, (String)" ", (String)".") + ".description");
            int type = 2;
            this.checkSystemRole(companyId, name, description, type);
            ++n;
        }
        String[] stringArray3 = systemOrganizationRoles = PortalUtil.getSystemOrganizationRoles();
        int n4 = systemOrganizationRoles.length;
        n3 = 0;
        while (n3 < n4) {
            String name = stringArray3[n3];
            String description = PropsUtil.get("system.organization.role." + StringUtil.replace((String)name, (String)" ", (String)".") + ".description");
            int type = 3;
            this.checkSystemRole(companyId, name, description, type);
            ++n3;
        }
    }

    @Override
    public void deleteRole(long roleId) throws PortalException, SystemException {
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        if (PortalUtil.isSystemRole((String)role.getName())) {
            throw new RequiredRoleException();
        }
        String className = role.getClassName();
        long classNameId = role.getClassNameId();
        if (classNameId <= 0L || className.equals(Role.class.getName())) {
            this.resourceLocalService.deleteResource(role.getCompanyId(), Role.class.getName(), 4, role.getRoleId());
        }
        if (role.getType() == 2 || role.getType() == 3) {
            this.userGroupRoleLocalService.deleteUserGroupRolesByRoleId(role.getRoleId());
            this.userGroupGroupRoleLocalService.deleteUserGroupGroupRolesByRoleId(role.getRoleId());
        }
        this.rolePersistence.remove((BaseModel)role);
        PermissionCacheUtil.clearCache();
    }

    public Role getDefaultGroupRole(long groupId) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        if (group.isLayout()) {
            Layout layout = this.layoutLocalService.getLayout(group.getClassPK());
            group = layout.getGroup();
        }
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        Role role = null;
        if (group.isCommunity() || group.isLayoutPrototype() || group.isLayoutSetPrototype()) {
            role = this.getRole(group.getCompanyId(), "Community Member");
        } else if (group.isCompany()) {
            role = this.getRole(group.getCompanyId(), "Administrator");
        } else if (group.isOrganization()) {
            role = this.getRole(group.getCompanyId(), "Organization Member");
        } else if (group.isUser() || group.isUserGroup()) {
            role = this.getRole(group.getCompanyId(), "Power User");
        }
        return role;
    }

    public List<Role> getGroupRoles(long groupId) throws SystemException {
        return this.groupPersistence.getRoles(groupId);
    }

    public Map<String, List<String>> getResourceRoles(long companyId, String name, int scope, String primKey) throws SystemException {
        return this.roleFinder.findByC_N_S_P(companyId, name, scope, primKey);
    }

    @Override
    public Role getRole(long roleId) throws PortalException, SystemException {
        return this.rolePersistence.findByPrimaryKey(roleId);
    }

    public Role getRole(long companyId, String name) throws PortalException, SystemException {
        Role role = this._systemRolesMap.get(String.valueOf(companyId) + name);
        if (role != null) {
            return role;
        }
        return this.rolePersistence.findByC_N(companyId, name);
    }

    public List<Role> getRoles(long companyId) throws SystemException {
        return this.rolePersistence.findByCompanyId(companyId);
    }

    public List<Role> getRoles(long[] roleIds) throws PortalException, SystemException {
        ArrayList<Role> roles = new ArrayList<Role>(roleIds.length);
        long[] lArray = roleIds;
        int n = roleIds.length;
        int n2 = 0;
        while (n2 < n) {
            long roleId = lArray[n2];
            Role role = this.getRole(roleId);
            roles.add(role);
            ++n2;
        }
        return roles;
    }

    public List<Role> getRoles(int type, String subtype) throws SystemException {
        return this.rolePersistence.findByT_S(type, subtype);
    }

    public List<Role> getSubtypeRoles(String subtype) throws SystemException {
        return this.rolePersistence.findBySubtype(subtype);
    }

    public int getSubtypeRolesCount(String subtype) throws SystemException {
        return this.rolePersistence.countBySubtype(subtype);
    }

    public Role getTeamRole(long companyId, long teamId) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId(Team.class);
        return this.rolePersistence.findByC_C_C(companyId, classNameId, teamId);
    }

    public List<Role> getUserGroupGroupRoles(long userId, long groupId) throws SystemException {
        return this.roleFinder.findByUserGroupGroupRole(userId, groupId);
    }

    public List<Role> getUserGroupRoles(long userId, long groupId) throws SystemException {
        return this.roleFinder.findByUserGroupRole(userId, groupId);
    }

    public List<Role> getUserRelatedRoles(long userId, long groupId) throws SystemException {
        return this.roleFinder.findByU_G(userId, groupId);
    }

    public List<Role> getUserRelatedRoles(long userId, long[] groupIds) throws SystemException {
        return this.roleFinder.findByU_G(userId, groupIds);
    }

    public List<Role> getUserRelatedRoles(long userId, List<Group> groups) throws SystemException {
        if (groups == null || groups.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.roleFinder.findByU_G(userId, groups);
    }

    public List<Role> getUserRoles(long userId) throws SystemException {
        return this.userPersistence.getRoles(userId);
    }

    public boolean hasUserRole(long userId, long roleId) throws SystemException {
        return this.userPersistence.containsRole(userId, roleId);
    }

    @ThreadLocalCachable
    public boolean hasUserRole(long userId, long companyId, String name, boolean inherited) throws PortalException, SystemException {
        Role role = this.rolePersistence.findByC_N(companyId, name);
        if (role.getType() != 1) {
            throw new IllegalArgumentException(String.valueOf(name) + " is not a regular role");
        }
        if (inherited) {
            return this.roleFinder.countByR_U(role.getRoleId(), userId) > 0;
        }
        return this.userPersistence.containsRole(userId, role.getRoleId());
    }

    public boolean hasUserRoles(long userId, long companyId, String[] names, boolean inherited) throws PortalException, SystemException {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (this.hasUserRole(userId, companyId, name, inherited)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public List<Role> search(long companyId, String name, String description, Integer[] types, int start, int end, OrderByComparator obc) throws SystemException {
        return this.search(companyId, name, description, types, new LinkedHashMap<String, Object>(), start, end, obc);
    }

    public List<Role> search(long companyId, String name, String description, Integer[] types, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        return this.roleFinder.findByC_N_D_T(companyId, name, description, types, params, start, end, obc);
    }

    public int searchCount(long companyId, String name, String description, Integer[] types) throws SystemException {
        return this.searchCount(companyId, name, description, types, new LinkedHashMap<String, Object>());
    }

    public int searchCount(long companyId, String name, String description, Integer[] types, LinkedHashMap<String, Object> params) throws SystemException {
        return this.roleFinder.countByC_N_D_T(companyId, name, description, types, params);
    }

    public void setUserRoles(long userId, long[] roleIds) throws PortalException, SystemException {
        roleIds = EnterpriseAdminUtil.addRequiredRoles((long)userId, (long[])roleIds);
        this.userPersistence.setRoles(userId, roleIds);
        Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
        indexer.reindex((Object)userId);
        PermissionCacheUtil.clearCache();
    }

    public void unsetUserRoles(long userId, long[] roleIds) throws PortalException, SystemException {
        roleIds = EnterpriseAdminUtil.removeRequiredRoles((long)userId, (long[])roleIds);
        this.userPersistence.removeRoles(userId, roleIds);
        Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
        indexer.reindex((Object)userId);
        PermissionCacheUtil.clearCache();
    }

    public Role updateRole(long roleId, String name, Map<Locale, String> titleMap, String description, String subtype) throws PortalException, SystemException {
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        this.validate(roleId, role.getCompanyId(), role.getClassNameId(), name);
        if (PortalUtil.isSystemRole((String)role.getName())) {
            name = role.getName();
            subtype = null;
        }
        role.setName(name);
        role.setTitleMap(titleMap);
        role.setDescription(description);
        role.setSubtype(subtype);
        this.rolePersistence.update((BaseModel)role, false);
        return role;
    }

    protected void checkSystemRole(long companyId, String name, String description, int type) throws PortalException, SystemException {
        Role role = this._systemRolesMap.get(String.valueOf(companyId) + name);
        try {
            if (role == null) {
                role = this.rolePersistence.findByC_N(companyId, name);
            }
            if (!role.getDescription().equals(description)) {
                role.setDescription(description);
                this.roleLocalService.updateRole(role, false);
            }
        }
        catch (NoSuchRoleException noSuchRoleException) {
            role = this.roleLocalService.addRole(0L, companyId, name, null, description, type);
        }
        this._systemRolesMap.put(String.valueOf(companyId) + name, role);
    }

    protected void validate(long roleId, long companyId, long classNameId, String name) throws PortalException, SystemException {
        if (classNameId == PortalUtil.getClassNameId(Role.class) && (Validator.isNull((String)name) || Validator.isNumber((String)name) || name.indexOf(",") != -1 || name.indexOf("*") != -1)) {
            throw new RoleNameException();
        }
        try {
            Role role = this.roleFinder.findByC_N(companyId, name);
            if (role.getRoleId() != roleId) {
                throw new DuplicateRoleException();
            }
        }
        catch (NoSuchRoleException noSuchRoleException) {}
    }
}

