/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.DuplicatePasswordPolicyException;
import com.liferay.portal.NoSuchPasswordPolicyRelException;
import com.liferay.portal.PasswordPolicyNameException;
import com.liferay.portal.RequiredPasswordPolicyException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.model.PasswordPolicyRel;
import com.liferay.portal.model.User;
import com.liferay.portal.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.service.base.PasswordPolicyLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordPolicyLocalServiceImpl
extends PasswordPolicyLocalServiceBaseImpl {
    public PasswordPolicy addPasswordPolicy(long userId, boolean defaultPolicy, String name, String description, boolean changeable, boolean changeRequired, long minAge, boolean checkSyntax, boolean allowDictionaryWords, int minAlphanumeric, int minLength, int minLowerCase, int minNumbers, int minSymbols, int minUpperCase, boolean history, int historyCount, boolean expireable, long maxAge, long warningTime, int graceLimit, boolean lockout, int maxFailure, long lockoutDuration, long resetFailureCount, long resetTicketMaxAge) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        this.validate(0L, user.getCompanyId(), name);
        long passwordPolicyId = this.counterLocalService.increment();
        PasswordPolicy passwordPolicy = this.passwordPolicyPersistence.create(passwordPolicyId);
        passwordPolicy.setUserId(userId);
        passwordPolicy.setCompanyId(user.getCompanyId());
        passwordPolicy.setUserName(user.getFullName());
        passwordPolicy.setCreateDate(now);
        passwordPolicy.setModifiedDate(now);
        passwordPolicy.setDefaultPolicy(defaultPolicy);
        passwordPolicy.setName(name);
        passwordPolicy.setDescription(description);
        passwordPolicy.setChangeable(changeable);
        passwordPolicy.setChangeRequired(changeRequired);
        passwordPolicy.setMinAge(minAge);
        passwordPolicy.setCheckSyntax(checkSyntax);
        passwordPolicy.setAllowDictionaryWords(allowDictionaryWords);
        passwordPolicy.setMinAlphanumeric(minAlphanumeric);
        passwordPolicy.setMinLength(minLength);
        passwordPolicy.setMinLowerCase(minLowerCase);
        passwordPolicy.setMinNumbers(minNumbers);
        passwordPolicy.setMinSymbols(minSymbols);
        passwordPolicy.setMinUpperCase(minUpperCase);
        passwordPolicy.setHistory(history);
        passwordPolicy.setHistoryCount(historyCount);
        passwordPolicy.setExpireable(expireable);
        passwordPolicy.setMaxAge(maxAge);
        passwordPolicy.setWarningTime(warningTime);
        passwordPolicy.setGraceLimit(graceLimit);
        passwordPolicy.setLockout(lockout);
        passwordPolicy.setMaxFailure(maxFailure);
        passwordPolicy.setLockoutDuration(lockoutDuration);
        passwordPolicy.setRequireUnlock(lockoutDuration == 0L);
        passwordPolicy.setResetFailureCount(resetFailureCount);
        passwordPolicy.setResetTicketMaxAge(resetTicketMaxAge);
        this.passwordPolicyPersistence.update((BaseModel)passwordPolicy, false);
        if (!user.isDefaultUser()) {
            this.resourceLocalService.addResources(user.getCompanyId(), 0L, userId, PasswordPolicy.class.getName(), passwordPolicy.getPasswordPolicyId(), false, false, false);
        }
        return passwordPolicy;
    }

    public void checkDefaultPasswordPolicy(long companyId) throws PortalException, SystemException {
        String defaultPasswordPolicyName = PropsValues.PASSWORDS_DEFAULT_POLICY_NAME;
        PasswordPolicy defaultPasswordPolicy = this.passwordPolicyPersistence.fetchByC_N(companyId, defaultPasswordPolicyName);
        if (defaultPasswordPolicy == null) {
            long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
            this.addPasswordPolicy(defaultUserId, true, defaultPasswordPolicyName, defaultPasswordPolicyName, true, false, 0L, false, true, 0, 6, 0, 1, 0, 1, false, 6, false, 8640000L, 86400L, 0, false, 3, 0L, 600L, 86400L);
        }
    }

    @Override
    public void deletePasswordPolicy(long passwordPolicyId) throws PortalException, SystemException {
        PasswordPolicy passwordPolicy = this.passwordPolicyPersistence.findByPrimaryKey(passwordPolicyId);
        if (passwordPolicy.isDefaultPolicy()) {
            throw new RequiredPasswordPolicyException();
        }
        this.passwordPolicyRelLocalService.deletePasswordPolicyRels(passwordPolicyId);
        this.resourceLocalService.deleteResource(passwordPolicy.getCompanyId(), PasswordPolicy.class.getName(), 4, passwordPolicy.getPasswordPolicyId());
        this.passwordPolicyPersistence.remove((BaseModel)passwordPolicy);
    }

    public PasswordPolicy getDefaultPasswordPolicy(long companyId) throws PortalException, SystemException {
        if (LDAPSettingsUtil.isPasswordPolicyEnabled(companyId)) {
            return null;
        }
        return this.passwordPolicyPersistence.findByC_DP(companyId, true);
    }

    @Override
    public PasswordPolicy getPasswordPolicy(long passwordPolicyId) throws PortalException, SystemException {
        return this.passwordPolicyPersistence.findByPrimaryKey(passwordPolicyId);
    }

    public PasswordPolicy getPasswordPolicy(long companyId, long organizationId, long locationId) throws PortalException, SystemException {
        return this.getPasswordPolicy(companyId, new long[]{organizationId, locationId});
    }

    public PasswordPolicy getPasswordPolicy(long companyId, long[] organizationIds) throws PortalException, SystemException {
        if (LDAPSettingsUtil.isPasswordPolicyEnabled(companyId)) {
            return null;
        }
        if (organizationIds == null || organizationIds.length == 0) {
            return this.getDefaultPasswordPolicy(companyId);
        }
        PasswordPolicyRel passwordPolicyRel = null;
        int i = 0;
        while (i < organizationIds.length) {
            long organizationId = organizationIds[i];
            try {
                passwordPolicyRel = this.passwordPolicyRelLocalService.getPasswordPolicyRel(Organization.class.getName(), organizationId);
                return this.getPasswordPolicy(passwordPolicyRel.getPasswordPolicyId());
            }
            catch (NoSuchPasswordPolicyRelException noSuchPasswordPolicyRelException) {
                ++i;
            }
        }
        return this.getDefaultPasswordPolicy(companyId);
    }

    public PasswordPolicy getPasswordPolicyByUserId(long userId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (LDAPSettingsUtil.isPasswordPolicyEnabled(user.getCompanyId())) {
            return null;
        }
        PasswordPolicyRel passwordPolicyRel = null;
        try {
            passwordPolicyRel = this.passwordPolicyRelLocalService.getPasswordPolicyRel(User.class.getName(), userId);
            return this.getPasswordPolicy(passwordPolicyRel.getPasswordPolicyId());
        }
        catch (NoSuchPasswordPolicyRelException noSuchPasswordPolicyRelException) {
            long[] organizationIds = user.getOrganizationIds();
            return this.getPasswordPolicy(user.getCompanyId(), organizationIds);
        }
    }

    public List<PasswordPolicy> search(long companyId, String name, int start, int end, OrderByComparator obc) throws SystemException {
        return this.passwordPolicyFinder.findByC_N(companyId, name, start, end, obc);
    }

    public int searchCount(long companyId, String name) throws SystemException {
        return this.passwordPolicyFinder.countByC_N(companyId, name);
    }

    public PasswordPolicy updatePasswordPolicy(long passwordPolicyId, String name, String description, boolean changeable, boolean changeRequired, long minAge, boolean checkSyntax, boolean allowDictionaryWords, int minAlphanumeric, int minLength, int minLowerCase, int minNumbers, int minSymbols, int minUpperCase, boolean history, int historyCount, boolean expireable, long maxAge, long warningTime, int graceLimit, boolean lockout, int maxFailure, long lockoutDuration, long resetFailureCount, long resetTicketMaxAge) throws PortalException, SystemException {
        Date now = new Date();
        PasswordPolicy passwordPolicy = this.passwordPolicyPersistence.findByPrimaryKey(passwordPolicyId);
        if (!passwordPolicy.getDefaultPolicy()) {
            this.validate(passwordPolicyId, passwordPolicy.getCompanyId(), name);
            passwordPolicy.setName(name);
        }
        passwordPolicy.setModifiedDate(now);
        passwordPolicy.setDescription(description);
        passwordPolicy.setChangeable(changeable);
        passwordPolicy.setChangeRequired(changeRequired);
        passwordPolicy.setMinAge(minAge);
        passwordPolicy.setCheckSyntax(checkSyntax);
        passwordPolicy.setAllowDictionaryWords(allowDictionaryWords);
        passwordPolicy.setMinAlphanumeric(minAlphanumeric);
        passwordPolicy.setMinLength(minLength);
        passwordPolicy.setMinLowerCase(minLowerCase);
        passwordPolicy.setMinNumbers(minNumbers);
        passwordPolicy.setMinSymbols(minSymbols);
        passwordPolicy.setMinUpperCase(minUpperCase);
        passwordPolicy.setHistory(history);
        passwordPolicy.setHistoryCount(historyCount);
        passwordPolicy.setExpireable(expireable);
        passwordPolicy.setMaxAge(maxAge);
        passwordPolicy.setWarningTime(warningTime);
        passwordPolicy.setGraceLimit(graceLimit);
        passwordPolicy.setLockout(lockout);
        passwordPolicy.setMaxFailure(maxFailure);
        passwordPolicy.setLockoutDuration(lockoutDuration);
        passwordPolicy.setRequireUnlock(lockoutDuration == 0L);
        passwordPolicy.setResetFailureCount(resetFailureCount);
        passwordPolicy.setResetTicketMaxAge(resetTicketMaxAge);
        this.passwordPolicyPersistence.update((BaseModel)passwordPolicy, false);
        return passwordPolicy;
    }

    protected void validate(long passwordPolicyId, long companyId, String name) throws PortalException, SystemException {
        if (Validator.isNull((String)name) || Validator.isNumber((String)name) || name.indexOf(44) != -1 || name.indexOf(42) != -1) {
            throw new PasswordPolicyNameException();
        }
        PasswordPolicy passwordPolicy = this.passwordPolicyPersistence.fetchByC_N(companyId, name);
        if (passwordPolicy != null && (passwordPolicyId <= 0L || passwordPolicy.getPasswordPolicyId() != passwordPolicyId)) {
            throw new DuplicatePasswordPolicyException();
        }
    }
}

