/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.base.LayoutSetServiceBaseImpl;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import java.io.File;

public class LayoutSetServiceImpl
extends LayoutSetServiceBaseImpl {
    public void updateLogo(long groupId, boolean privateLayout, boolean logo, File file) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_LAYOUTS");
        this.layoutSetLocalService.updateLogo(groupId, privateLayout, logo, file);
    }

    public LayoutSet updateLookAndFeel(long groupId, boolean privateLayout, String themeId, String colorSchemeId, String css, boolean wapTheme) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_LAYOUTS");
        this.pluginSettingLocalService.checkPermission(this.getUserId(), themeId, "theme");
        return this.layoutSetLocalService.updateLookAndFeel(groupId, privateLayout, themeId, colorSchemeId, css, wapTheme);
    }

    public LayoutSet updateSettings(long groupId, boolean privateLayout, String settings) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_LAYOUTS");
        return this.layoutSetLocalService.updateSettings(groupId, privateLayout, settings);
    }

    public LayoutSet updateVirtualHost(long groupId, boolean privateLayout, String virtualHost) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"UPDATE");
        return this.layoutSetLocalService.updateVirtualHost(groupId, privateLayout, virtualHost);
    }
}

