/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.ImageTypeException;
import com.liferay.portal.NoSuchImageException;
import com.liferay.portal.image.DatabaseHook;
import com.liferay.portal.image.HookFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.Hook;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageProcessorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ImageServletTokenUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.impl.ImageImpl;
import com.liferay.portal.service.base.ImageLocalServiceBaseImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageLocalServiceImpl
extends ImageLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(ImageLocalServiceImpl.class);
    private Image _defaultSpacer;
    private Image _defaultCompanyLogo;
    private Image _defaultOrganizationLogo;
    private Image _defaultUserFemalePortrait;
    private Image _defaultUserMalePortrait;

    public void afterPropertiesSet() {
        InputStream is;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            is = classLoader.getResourceAsStream(PropsUtil.get("image.default.spacer"));
            if (is == null) {
                _log.error((Object)"Default spacer is not available");
            }
            this._defaultSpacer = this.getImage(is);
        }
        catch (Exception ioe) {
            _log.error((Object)("Unable to configure the default spacer: " + ioe.getMessage()));
        }
        try {
            is = classLoader.getResourceAsStream(PropsUtil.get("image.default.company.logo"));
            if (is == null) {
                _log.error((Object)"Default company logo is not available");
            }
            this._defaultCompanyLogo = this.getImage(is);
        }
        catch (Exception ioe) {
            _log.error((Object)("Unable to configure the default company logo: " + ioe.getMessage()));
        }
        try {
            is = classLoader.getResourceAsStream(PropsUtil.get("image.default.organization.logo"));
            if (is == null) {
                _log.error((Object)"Default organization logo is not available");
            }
            this._defaultOrganizationLogo = this.getImage(is);
        }
        catch (Exception ioe) {
            _log.error((Object)("Unable to configure the default organization logo: " + ioe.getMessage()));
        }
        try {
            is = classLoader.getResourceAsStream(PropsUtil.get("image.default.user.female.portrait"));
            if (is == null) {
                _log.error((Object)"Default user female portrait is not available");
            }
            this._defaultUserFemalePortrait = this.getImage(is);
        }
        catch (Exception ioe) {
            _log.error((Object)("Unable to configure the default user female portrait: " + ioe.getMessage()));
        }
        try {
            is = classLoader.getResourceAsStream(PropsUtil.get("image.default.user.male.portrait"));
            if (is == null) {
                _log.error((Object)"Default user male portrait is not available");
            }
            this._defaultUserMalePortrait = this.getImage(is);
        }
        catch (Exception ioe) {
            _log.error((Object)("Unable to configure the default user male portrait: " + ioe.getMessage()));
        }
    }

    @Override
    public void deleteImage(long imageId) throws PortalException, SystemException {
        if (imageId <= 0L) {
            return;
        }
        if (PropsValues.IMAGE_HOOK_IMPL.equals(DatabaseHook.class.getName()) && this.imagePersistence.getListeners().length == 0) {
            this.runSQL("delete from Image where imageId = " + imageId);
            this.imagePersistence.clearCache();
        } else {
            try {
                Image image = this.getImage(imageId);
                this.imagePersistence.remove(imageId);
                Hook hook = HookFactory.getInstance();
                hook.deleteImage(image);
            }
            catch (NoSuchImageException noSuchImageException) {}
        }
    }

    public Image getCompanyLogo(long imageId) {
        Image image = this.getImage(imageId);
        if (image == null) {
            image = this.getDefaultCompanyLogo();
        }
        return image;
    }

    public Image getDefaultCompanyLogo() {
        return this._defaultCompanyLogo;
    }

    public Image getDefaultOrganizationLogo() {
        return this._defaultOrganizationLogo;
    }

    public Image getDefaultSpacer() {
        return this._defaultSpacer;
    }

    public Image getDefaultUserFemalePortrait() {
        return this._defaultUserFemalePortrait;
    }

    public Image getDefaultUserMalePortrait() {
        return this._defaultUserMalePortrait;
    }

    @Override
    public Image getImage(long imageId) {
        block3: {
            try {
                if (imageId > 0L) {
                    return this.imagePersistence.findByPrimaryKey(imageId);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)("Unable to get image " + imageId + ": " + e.getMessage()));
            }
        }
        return null;
    }

    public Image getImage(byte[] bytes) throws PortalException, SystemException {
        return this.getImage(null, bytes);
    }

    public Image getImage(File file) throws PortalException, SystemException {
        try {
            return this.getImage(new FileInputStream(file));
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public Image getImage(InputStream is) throws PortalException, SystemException {
        return this.getImage(is, null);
    }

    public Image getImageOrDefault(long imageId) {
        Image image = this.getImage(imageId);
        if (image == null) {
            image = this.getDefaultSpacer();
        }
        return image;
    }

    public List<Image> getImages() throws SystemException {
        return this.imagePersistence.findAll();
    }

    @Override
    public List<Image> getImages(int start, int end) throws SystemException {
        return this.imagePersistence.findAll(start, end);
    }

    public List<Image> getImagesBySize(int size) throws SystemException {
        return this.imagePersistence.findByLtSize(size);
    }

    public boolean isNullOrDefaultSpacer(byte[] bytes) {
        return bytes == null || bytes.length == 0 || Arrays.equals(bytes, this.getDefaultSpacer().getTextObj());
    }

    public Image updateImage(long imageId, byte[] bytes) throws PortalException, SystemException {
        Image image = this.getImage(bytes);
        return this.updateImage(imageId, image.getTextObj(), image.getType(), image.getHeight(), image.getWidth(), image.getSize());
    }

    public Image updateImage(long imageId, File file) throws PortalException, SystemException {
        Image image = this.getImage(file);
        return this.updateImage(imageId, image.getTextObj(), image.getType(), image.getHeight(), image.getWidth(), image.getSize());
    }

    public Image updateImage(long imageId, InputStream is) throws PortalException, SystemException {
        Image image = this.getImage(is);
        return this.updateImage(imageId, image.getTextObj(), image.getType(), image.getHeight(), image.getWidth(), image.getSize());
    }

    public Image updateImage(long imageId, byte[] bytes, String type, int height, int width, int size) throws PortalException, SystemException {
        Image image = this.imagePersistence.fetchByPrimaryKey(imageId);
        if (image == null) {
            image = this.imagePersistence.create(imageId);
        }
        image.setModifiedDate(new Date());
        image.setType(type);
        image.setHeight(height);
        image.setWidth(width);
        image.setSize(size);
        Hook hook = HookFactory.getInstance();
        hook.updateImage(image, type, bytes);
        this.imagePersistence.update((BaseModel)image, false);
        ImageServletTokenUtil.resetToken((long)imageId);
        return image;
    }

    protected Image getImage(InputStream is, byte[] bytes) throws PortalException, SystemException {
        try {
            if (is != null) {
                bytes = FileUtil.getBytes((InputStream)is);
            }
            ImageBag imageBag = ImageProcessorUtil.read((byte[])bytes);
            RenderedImage renderedImage = imageBag.getRenderedImage();
            String type = imageBag.getType();
            if (renderedImage == null) {
                throw new ImageTypeException();
            }
            int height = renderedImage.getHeight();
            int width = renderedImage.getWidth();
            int size = bytes.length;
            ImageImpl image = new ImageImpl();
            image.setTextObj(bytes);
            image.setType(type);
            image.setHeight(height);
            image.setWidth(width);
            image.setSize(size);
            ImageImpl imageImpl = image;
            return imageImpl;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            block12: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {
                        if (!_log.isWarnEnabled()) break block12;
                        _log.warn((Throwable)ioe);
                    }
                }
            }
        }
    }
}

