/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.CountryA2Exception;
import com.liferay.portal.CountryA3Exception;
import com.liferay.portal.CountryIddException;
import com.liferay.portal.CountryNameException;
import com.liferay.portal.CountryNumberException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Country;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.base.CountryServiceBaseImpl;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountryServiceImpl
extends CountryServiceBaseImpl {
    public Country addCountry(String name, String a2, String a3, String number, String idd, boolean active) throws PortalException, SystemException {
        if (!this.getPermissionChecker().isOmniadmin()) {
            throw new PrincipalException();
        }
        if (Validator.isNull((String)name)) {
            throw new CountryNameException();
        }
        if (Validator.isNull((String)a2)) {
            throw new CountryA2Exception();
        }
        if (Validator.isNull((String)a3)) {
            throw new CountryA3Exception();
        }
        if (Validator.isNull((String)number)) {
            throw new CountryNumberException();
        }
        if (Validator.isNull((String)idd)) {
            throw new CountryIddException();
        }
        long countryId = this.counterLocalService.increment();
        Country country = this.countryPersistence.create(countryId);
        country.setName(name);
        country.setA2(a2);
        country.setA3(a3);
        country.setNumber(number);
        country.setIdd(idd);
        country.setActive(active);
        this.countryPersistence.update((BaseModel)country, false);
        return country;
    }

    public List<Country> getCountries() throws SystemException {
        return this.countryPersistence.findAll();
    }

    public List<Country> getCountries(boolean active) throws SystemException {
        return this.countryPersistence.findByActive(active);
    }

    public Country getCountry(long countryId) throws PortalException, SystemException {
        return this.countryPersistence.findByPrimaryKey(countryId);
    }

    public Country getCountryByA2(String a2) throws PortalException, SystemException {
        return this.countryPersistence.findByA2(a2);
    }

    public Country getCountryByA3(String a3) throws PortalException, SystemException {
        return this.countryPersistence.findByA3(a3);
    }

    public Country getCountryByName(String name) throws PortalException, SystemException {
        return this.countryPersistence.findByName(name);
    }
}

