/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Account;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.Phone;
import com.liferay.portal.model.Website;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.base.CompanyServiceBaseImpl;
import com.liferay.portlet.enterpriseadmin.util.EnterpriseAdminUtil;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompanyServiceImpl
extends CompanyServiceBaseImpl {
    public Company addCompany(String webId, String virtualHost, String mx, String shardName, boolean system, int maxUsers) throws PortalException, SystemException {
        if (!this.getPermissionChecker().isOmniadmin()) {
            throw new PrincipalException();
        }
        return this.companyLocalService.addCompany(webId, virtualHost, mx, shardName, system, maxUsers);
    }

    public void deleteLogo(long companyId) throws PortalException, SystemException {
        if (!this.roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        this.companyLocalService.deleteLogo(companyId);
    }

    public Company getCompanyById(long companyId) throws PortalException, SystemException {
        return this.companyLocalService.getCompanyById(companyId);
    }

    public Company getCompanyByLogoId(long logoId) throws PortalException, SystemException {
        return this.companyLocalService.getCompanyByLogoId(logoId);
    }

    public Company getCompanyByMx(String mx) throws PortalException, SystemException {
        return this.companyLocalService.getCompanyByMx(mx);
    }

    public Company getCompanyByVirtualHost(String virtualHost) throws PortalException, SystemException {
        return this.companyLocalService.getCompanyByVirtualHost(virtualHost);
    }

    public Company getCompanyByWebId(String webId) throws PortalException, SystemException {
        return this.companyLocalService.getCompanyByWebId(webId);
    }

    public void removePreferences(long companyId, String[] keys) throws PortalException, SystemException {
        if (!this.roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        this.companyLocalService.removePreferences(companyId, keys);
    }

    public Company updateCompany(long companyId, String virtualHost, String mx, int maxUsers) throws PortalException, SystemException {
        if (!this.getPermissionChecker().isOmniadmin()) {
            throw new PrincipalException();
        }
        return this.companyLocalService.updateCompany(companyId, virtualHost, mx, maxUsers);
    }

    public Company updateCompany(long companyId, String virtualHost, String mx, String homeURL, String name, String legalName, String legalId, String legalType, String sicCode, String tickerSymbol, String industry, String type, String size) throws PortalException, SystemException {
        if (!this.roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        return this.companyLocalService.updateCompany(companyId, virtualHost, mx, homeURL, name, legalName, legalId, legalType, sicCode, tickerSymbol, industry, type, size);
    }

    public Company updateCompany(long companyId, String virtualHost, String mx, String homeURL, String name, String legalName, String legalId, String legalType, String sicCode, String tickerSymbol, String industry, String type, String size, String languageId, String timeZoneId, List<Address> addresses, List<EmailAddress> emailAddresses, List<Phone> phones, List<Website> websites, UnicodeProperties properties) throws PortalException, SystemException {
        Company company = this.updateCompany(companyId, virtualHost, mx, homeURL, name, legalName, legalId, legalType, sicCode, tickerSymbol, industry, type, size);
        this.updateDisplay(company.getCompanyId(), languageId, timeZoneId);
        this.updatePreferences(company.getCompanyId(), properties);
        EnterpriseAdminUtil.updateAddresses((String)Account.class.getName(), (long)company.getAccountId(), addresses);
        EnterpriseAdminUtil.updateEmailAddresses((String)Account.class.getName(), (long)company.getAccountId(), emailAddresses);
        EnterpriseAdminUtil.updatePhones((String)Account.class.getName(), (long)company.getAccountId(), phones);
        EnterpriseAdminUtil.updateWebsites((String)Account.class.getName(), (long)company.getAccountId(), websites);
        return company;
    }

    public void updateDisplay(long companyId, String languageId, String timeZoneId) throws PortalException, SystemException {
        if (!this.roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        this.companyLocalService.updateDisplay(companyId, languageId, timeZoneId);
    }

    public void updateLogo(long companyId, File file) throws PortalException, SystemException {
        if (!this.roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        this.companyLocalService.updateLogo(companyId, file);
    }

    public void updatePreferences(long companyId, UnicodeProperties properties) throws PortalException, SystemException {
        if (!this.roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        this.companyLocalService.updatePreferences(companyId, properties);
    }

    public void updateSecurity(long companyId, String authType, boolean autoLogin, boolean sendPassword, boolean strangers, boolean strangersWithMx, boolean strangersVerify, boolean communityLogo) throws PortalException, SystemException {
        if (!this.roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        this.companyLocalService.updateSecurity(companyId, authType, autoLogin, sendPassword, strangers, strangersWithMx, strangersVerify, communityLogo);
    }
}

