/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.AccountNameException;
import com.liferay.portal.CompanyMxException;
import com.liferay.portal.CompanyVirtualHostException;
import com.liferay.portal.CompanyWebIdException;
import com.liferay.portal.NoSuchCompanyException;
import com.liferay.portal.NoSuchLayoutSetException;
import com.liferay.portal.NoSuchShardException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Account;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.CompanyLocalServiceBaseImpl;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.Encryptor;
import com.liferay.util.EncryptorException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompanyLocalServiceImpl
extends CompanyLocalServiceBaseImpl {
    private static final String _DEFAULT_VIRTUAL_HOST = "localhost";
    private static final String[] _KEYWORDS_FIELDS = new String[]{"assetTagNames", "content", "description", "properties", "title"};

    public Company addCompany(String webId, String virtualHost, String mx, String shardName, boolean system, int maxUsers) throws PortalException, SystemException {
        virtualHost = virtualHost.trim().toLowerCase();
        if (Validator.isNull((String)webId) || webId.equals(PropsValues.COMPANY_DEFAULT_WEB_ID) || this.companyPersistence.fetchByWebId(webId) != null) {
            throw new CompanyWebIdException();
        }
        this.validate(webId, virtualHost, mx);
        Company company = this.checkCompany(webId, mx, shardName);
        company.setVirtualHost(virtualHost);
        company.setMx(mx);
        company.setSystem(system);
        company.setMaxUsers(maxUsers);
        this.companyPersistence.update((BaseModel)company, false);
        return company;
    }

    public Company checkCompany(String webId) throws PortalException, SystemException {
        String mx = webId;
        return this.companyLocalService.checkCompany(webId, mx, PropsValues.SHARD_DEFAULT_NAME);
    }

    public Company checkCompany(String webId, String mx, String shardName) throws PortalException, SystemException {
        Date now = new Date();
        Company company = this.companyPersistence.fetchByWebId(webId);
        if (company == null) {
            String virtualHost = webId;
            if (webId.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
                virtualHost = _DEFAULT_VIRTUAL_HOST;
            }
            String homeURL = null;
            String name = webId;
            String legalName = null;
            String legalId = null;
            String legalType = null;
            String sicCode = null;
            String tickerSymbol = null;
            String industry = null;
            String type = null;
            String size = null;
            long companyId = this.counterLocalService.increment();
            company = this.companyPersistence.create(companyId);
            try {
                company.setKeyObj(Encryptor.generateKey());
            }
            catch (EncryptorException ee) {
                throw new SystemException((Throwable)ee);
            }
            company.setWebId(webId);
            company.setVirtualHost(virtualHost);
            company.setMx(mx);
            this.companyPersistence.update((BaseModel)company, false);
            this.shardLocalService.addShard(Company.class.getName(), companyId, shardName);
            this.updateCompany(companyId, virtualHost, mx, homeURL, name, legalName, legalId, legalType, sicCode, tickerSymbol, industry, type, size);
            if (webId.equals("liferay.net")) {
                company = this.companyPersistence.findByWebId(webId);
                company.setVirtualHost("demo.liferay.net");
                this.companyPersistence.update((BaseModel)company, false);
                this.updateSecurity(companyId, "emailAddress", true, true, true, true, false, true);
                PortletPreferences preferences = PrefsPropsUtil.getPreferences(companyId);
                try {
                    preferences.setValue("admin.email.from.name", "Liferay Demo");
                    preferences.setValue("admin.email.from.address", "test@liferay.net");
                    preferences.store();
                }
                catch (IOException ioe) {
                    throw new SystemException((Throwable)ioe);
                }
                catch (PortletException pe) {
                    throw new SystemException((Throwable)pe);
                }
            }
        } else {
            try {
                this.shardLocalService.getShard(Company.class.getName(), company.getCompanyId());
            }
            catch (NoSuchShardException noSuchShardException) {
                this.shardLocalService.addShard(Company.class.getName(), company.getCompanyId(), shardName);
            }
        }
        long companyId = company.getCompanyId();
        this.checkCompanyKey(companyId);
        User defaultUser = null;
        try {
            defaultUser = this.userLocalService.getDefaultUser(companyId);
            if (!defaultUser.isAgreedToTermsOfUse()) {
                defaultUser.setAgreedToTermsOfUse(true);
                this.userPersistence.update((BaseModel)defaultUser, false);
            }
        }
        catch (NoSuchUserException noSuchUserException) {
            long userId = this.counterLocalService.increment();
            defaultUser = this.userPersistence.create(userId);
            defaultUser.setCompanyId(companyId);
            defaultUser.setCreateDate(now);
            defaultUser.setModifiedDate(now);
            defaultUser.setDefaultUser(true);
            defaultUser.setContactId(this.counterLocalService.increment());
            defaultUser.setPassword("password");
            defaultUser.setScreenName(String.valueOf(defaultUser.getUserId()));
            defaultUser.setEmailAddress("default@" + company.getMx());
            defaultUser.setLanguageId(LocaleUtil.getDefault().toString());
            defaultUser.setTimeZoneId(TimeZoneUtil.getDefault().getID());
            defaultUser.setGreeting(LanguageUtil.format((Locale)defaultUser.getLocale(), (String)"welcome-x", (Object)"", (boolean)false));
            defaultUser.setLoginDate(now);
            defaultUser.setFailedLoginAttempts(0);
            defaultUser.setAgreedToTermsOfUse(true);
            defaultUser.setActive(true);
            this.userPersistence.update((BaseModel)defaultUser, false);
            Contact defaultContact = this.contactPersistence.create(defaultUser.getContactId());
            defaultContact.setCompanyId(defaultUser.getCompanyId());
            defaultContact.setUserId(defaultUser.getUserId());
            defaultContact.setUserName("");
            defaultContact.setCreateDate(now);
            defaultContact.setModifiedDate(now);
            defaultContact.setAccountId(company.getAccountId());
            defaultContact.setParentContactId(0L);
            defaultContact.setFirstName("");
            defaultContact.setMiddleName("");
            defaultContact.setLastName("");
            defaultContact.setMale(true);
            defaultContact.setBirthday(now);
            this.contactPersistence.update((BaseModel)defaultContact, false);
        }
        this.roleLocalService.checkSystemRoles(companyId);
        this.groupLocalService.checkSystemGroups(companyId);
        this.groupLocalService.checkCompanyGroup(companyId);
        this.passwordPolicyLocalService.checkDefaultPasswordPolicy(companyId);
        Role guestRole = this.roleLocalService.getRole(companyId, "Guest");
        this.roleLocalService.setUserRoles(defaultUser.getUserId(), new long[]{guestRole.getRoleId()});
        if (this.userPersistence.countByCompanyId(companyId) == 1) {
            String password1;
            long creatorUserId = 0L;
            boolean autoPassword = false;
            String password2 = password1 = PropsValues.DEFAULT_ADMIN_PASSWORD;
            boolean autoScreenName = false;
            String screenName = PropsValues.DEFAULT_ADMIN_SCREEN_NAME;
            String emailAddress = String.valueOf(PropsValues.DEFAULT_ADMIN_EMAIL_ADDRESS_PREFIX) + "@" + mx;
            long facebookId = 0L;
            String openId = "";
            Locale locale = defaultUser.getLocale();
            String firstName = PropsValues.DEFAULT_ADMIN_FIRST_NAME;
            String middleName = PropsValues.DEFAULT_ADMIN_MIDDLE_NAME;
            String lastName = PropsValues.DEFAULT_ADMIN_LAST_NAME;
            int prefixId = 0;
            int suffixId = 0;
            boolean male = true;
            int birthdayMonth = 0;
            int birthdayDay = 1;
            int birthdayYear = 1970;
            String jobTitle = "";
            Group guestGroup = this.groupLocalService.getGroup(companyId, "Guest");
            long[] groupIds = new long[]{guestGroup.getGroupId()};
            long[] organizationIds = null;
            Role adminRole = this.roleLocalService.getRole(companyId, "Administrator");
            Role powerUserRole = this.roleLocalService.getRole(companyId, "Power User");
            long[] roleIds = new long[]{adminRole.getRoleId(), powerUserRole.getRoleId()};
            long[] userGroupIds = null;
            boolean sendEmail = false;
            ServiceContext serviceContext = new ServiceContext();
            this.userLocalService.addUser(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
        }
        this.portletLocalService.checkPortlets(companyId);
        return company;
    }

    public void checkCompanyKey(long companyId) throws PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        if (Validator.isNull((String)company.getKey()) && company.getKeyObj() == null) {
            try {
                company.setKeyObj(Encryptor.generateKey());
            }
            catch (EncryptorException ee) {
                throw new SystemException((Throwable)ee);
            }
            this.companyPersistence.update((BaseModel)company, false);
        }
    }

    public void deleteLogo(long companyId) throws PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        long logoId = company.getLogoId();
        if (logoId > 0L) {
            company.setLogoId(0L);
            this.companyPersistence.update((BaseModel)company, false);
            this.imageLocalService.deleteImage(logoId);
        }
    }

    public List<Company> getCompanies() throws SystemException {
        return this.companyPersistence.findAll();
    }

    public List<Company> getCompanies(boolean system) throws SystemException {
        return this.companyPersistence.findBySystem(system);
    }

    public int getCompaniesCount(boolean system) throws SystemException {
        return this.companyPersistence.countBySystem(system);
    }

    public Company getCompanyById(long companyId) throws PortalException, SystemException {
        return this.companyPersistence.findByPrimaryKey(companyId);
    }

    public Company getCompanyByLogoId(long logoId) throws PortalException, SystemException {
        return this.companyPersistence.findByLogoId(logoId);
    }

    public Company getCompanyByMx(String mx) throws PortalException, SystemException {
        return this.companyPersistence.findByMx(mx);
    }

    public Company getCompanyByVirtualHost(String virtualHost) throws PortalException, SystemException {
        virtualHost = virtualHost.trim().toLowerCase();
        return this.companyPersistence.findByVirtualHost(virtualHost);
    }

    public Company getCompanyByWebId(String webId) throws PortalException, SystemException {
        return this.companyPersistence.findByWebId(webId);
    }

    public void removePreferences(long companyId, String[] keys) throws SystemException {
        PortletPreferences preferences = PrefsPropsUtil.getPreferences(companyId);
        try {
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                preferences.reset(key);
                ++n2;
            }
            preferences.store();
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public Hits search(long companyId, long userId, String keywords, int start, int end) throws SystemException {
        return this.search(companyId, userId, null, 0L, null, keywords, start, end);
    }

    public Hits search(long companyId, long userId, String portletId, long groupId, String type, String keywords, int start, int end) throws SystemException {
        try {
            BooleanQuery contextQuery = BooleanQueryFactoryUtil.create();
            contextQuery.addRequiredTerm("companyId", companyId);
            if (Validator.isNotNull((String)portletId)) {
                contextQuery.addRequiredTerm("portletId", portletId);
            }
            if (groupId > 0L) {
                contextQuery.addRequiredTerm("groupId", groupId);
            }
            if (Validator.isNotNull((String)type)) {
                contextQuery.addRequiredTerm("type", type);
            }
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create();
            searchQuery.addTerms(_KEYWORDS_FIELDS, keywords);
            BooleanQuery fullQuery = BooleanQueryFactoryUtil.create();
            fullQuery.add((Query)contextQuery, BooleanClauseOccur.MUST);
            if (searchQuery.clauses().size() > 0) {
                fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
            }
            return SearchEngineUtil.search((long)companyId, (long[])new long[]{groupId}, (long)userId, null, (Query)fullQuery, (int)start, (int)end);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public Company updateCompany(long companyId, String virtualHost, String mx, int maxUsers) throws PortalException, SystemException {
        virtualHost = virtualHost.trim().toLowerCase();
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        this.validate(company.getWebId(), virtualHost, mx);
        company.setVirtualHost(virtualHost);
        if (PropsValues.MAIL_MX_UPDATE) {
            company.setMx(mx);
        }
        company.setMaxUsers(maxUsers);
        this.companyPersistence.update((BaseModel)company, false);
        return company;
    }

    public Company updateCompany(long companyId, String virtualHost, String mx, String homeURL, String name, String legalName, String legalId, String legalType, String sicCode, String tickerSymbol, String industry, String type, String size) throws PortalException, SystemException {
        virtualHost = virtualHost.trim().toLowerCase();
        Date now = new Date();
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        this.validate(company.getWebId(), virtualHost, mx);
        this.validate(name);
        company.setVirtualHost(virtualHost);
        if (PropsValues.MAIL_MX_UPDATE) {
            company.setMx(mx);
        }
        company.setHomeURL(homeURL);
        this.companyPersistence.update((BaseModel)company, false);
        Account account = this.accountPersistence.fetchByPrimaryKey(company.getAccountId());
        if (account == null) {
            long accountId = this.counterLocalService.increment();
            account = this.accountPersistence.create(accountId);
            account.setCreateDate(now);
            account.setCompanyId(companyId);
            account.setUserId(0L);
            account.setUserName("");
            company.setAccountId(accountId);
            this.companyPersistence.update((BaseModel)company, false);
        }
        account.setModifiedDate(now);
        account.setName(name);
        account.setLegalName(legalName);
        account.setLegalId(legalId);
        account.setLegalType(legalType);
        account.setSicCode(sicCode);
        account.setTickerSymbol(tickerSymbol);
        account.setIndustry(industry);
        account.setType(type);
        account.setSize(size);
        this.accountPersistence.update((BaseModel)account, false);
        return company;
    }

    public void updateDisplay(long companyId, String languageId, String timeZoneId) throws PortalException, SystemException {
        User user = this.userLocalService.getDefaultUser(companyId);
        user.setLanguageId(languageId);
        user.setTimeZoneId(timeZoneId);
        this.userPersistence.update((BaseModel)user, false);
    }

    public void updateLogo(long companyId, byte[] bytes) throws PortalException, SystemException {
        long logoId = this.getLogoId(companyId);
        this.imageLocalService.updateImage(logoId, bytes);
    }

    public void updateLogo(long companyId, File file) throws PortalException, SystemException {
        long logoId = this.getLogoId(companyId);
        this.imageLocalService.updateImage(logoId, file);
    }

    public void updateLogo(long companyId, InputStream is) throws PortalException, SystemException {
        long logoId = this.getLogoId(companyId);
        this.imageLocalService.updateImage(logoId, is);
    }

    public void updatePreferences(long companyId, UnicodeProperties properties) throws SystemException {
        PortletPreferences preferences = PrefsPropsUtil.getPreferences(companyId);
        try {
            String newLocales;
            String oldLocales;
            if (properties.containsKey((Object)"locales") && !Validator.equals((Object)(oldLocales = preferences.getValue("locales", "")), (Object)(newLocales = properties.getProperty("locales")))) {
                LanguageUtil.resetAvailableLocales((long)companyId);
            }
            for (Map.Entry entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value.equals("TEMP_OBFUSCATION_VALUE")) continue;
                preferences.setValue(key, value);
            }
            preferences.store();
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public void updateSecurity(long companyId, String authType, boolean autoLogin, boolean sendPassword, boolean strangers, boolean strangersWithMx, boolean strangersVerify, boolean communityLogo) throws SystemException {
        PortletPreferences preferences = PrefsPropsUtil.getPreferences(companyId);
        try {
            preferences.setValue("company.security.auth.type", authType);
            preferences.setValue("company.security.auto.login", String.valueOf(autoLogin));
            preferences.setValue("company.security.send.password", String.valueOf(sendPassword));
            preferences.setValue("company.security.strangers", String.valueOf(strangers));
            preferences.setValue("company.security.strangers.with.mx", String.valueOf(strangersWithMx));
            preferences.setValue("company.security.strangers.verify", String.valueOf(strangersVerify));
            preferences.setValue("company.security.community.logo", String.valueOf(communityLogo));
            preferences.store();
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        catch (PortletException pe) {
            throw new SystemException((Throwable)pe);
        }
    }

    protected long getLogoId(long companyId) throws PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        long logoId = company.getLogoId();
        if (logoId <= 0L) {
            logoId = this.counterLocalService.increment();
            company.setLogoId(logoId);
            this.companyPersistence.update((BaseModel)company, false);
        }
        return logoId;
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new AccountNameException();
        }
    }

    protected void validate(String webId, String virtualHost, String mx) throws PortalException, SystemException {
        if (Validator.isNull((String)virtualHost)) {
            throw new CompanyVirtualHostException();
        }
        if (virtualHost.equals(_DEFAULT_VIRTUAL_HOST) && !webId.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
            throw new CompanyVirtualHostException();
        }
        if (!Validator.isDomain((String)virtualHost)) {
            throw new CompanyVirtualHostException();
        }
        try {
            Company virtualHostCompany = this.getCompanyByVirtualHost(virtualHost);
            if (virtualHostCompany != null && !virtualHostCompany.getWebId().equals(webId)) {
                throw new CompanyVirtualHostException();
            }
        }
        catch (NoSuchCompanyException noSuchCompanyException) {}
        try {
            this.layoutSetLocalService.getLayoutSet(virtualHost);
            throw new CompanyVirtualHostException();
        }
        catch (NoSuchLayoutSetException noSuchLayoutSetException) {
            if (Validator.isNull((String)mx)) {
                throw new CompanyMxException();
            }
            if (!Validator.isDomain((String)mx)) {
                throw new CompanyMxException();
            }
            return;
        }
    }
}

