/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.LayoutSetPrototypeServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutSetPrototypeServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(LayoutSetPrototypeServiceHttp.class);

    public static LayoutSetPrototype addLayoutSetPrototype(HttpPrincipal httpPrincipal, Map<Locale, String> nameMap, String description, boolean active) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutSetPrototypeServiceUtil.class.getName(), "addLayoutSetPrototype", new Class[]{Map.class, String.class, Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nameMap, description, active});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (LayoutSetPrototype)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteLayoutSetPrototype(HttpPrincipal httpPrincipal, long layoutSetPrototypeId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutSetPrototypeServiceUtil.class.getName(), "deleteLayoutSetPrototype", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{layoutSetPrototypeId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static LayoutSetPrototype getLayoutSetPrototype(HttpPrincipal httpPrincipal, long layoutSetPrototypeId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutSetPrototypeServiceUtil.class.getName(), "getLayoutSetPrototype", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{layoutSetPrototypeId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (LayoutSetPrototype)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<LayoutSetPrototype> search(HttpPrincipal httpPrincipal, long companyId, Boolean active, OrderByComparator obc) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutSetPrototypeServiceUtil.class.getName(), "search", new Class[]{Long.TYPE, Boolean.class, OrderByComparator.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, active, obc});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static LayoutSetPrototype updateLayoutSetPrototype(HttpPrincipal httpPrincipal, long layoutSetPrototypeId, Map<Locale, String> nameMap, String description, boolean active) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutSetPrototypeServiceUtil.class.getName(), "updateLayoutSetPrototype", new Class[]{Long.TYPE, Map.class, String.class, Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{layoutSetPrototypeId, nameMap, description, active});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (LayoutSetPrototype)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

