/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutReference;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(LayoutServiceHttp.class);

    public static Layout addLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, String description, String type, boolean hidden, String friendlyURL, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "addLayout", new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Map.class, Map.class, String.class, String.class, Boolean.TYPE, String.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parentLayoutId, localeNamesMap, localeTitlesMap, description, type, hidden, friendlyURL, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout addLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long parentLayoutId, String name, String title, String description, String type, boolean hidden, String friendlyURL, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "addLayout", new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, String.class, String.class, String.class, String.class, Boolean.TYPE, String.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parentLayoutId, name, title, description, type, hidden, friendlyURL, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteLayout(HttpPrincipal httpPrincipal, long plid) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "deleteLayout", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "deleteLayout", new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static byte[] exportLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "exportLayouts", new Class[]{Long.TYPE, Boolean.TYPE, long[].class, Map.class, Date.class, Date.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutIds, parameterMap, startDate, endDate});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (byte[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static byte[] exportLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "exportLayouts", new Class[]{Long.TYPE, Boolean.TYPE, Map.class, Date.class, Date.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parameterMap, startDate, endDate});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (byte[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static File exportLayoutsAsFile(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "exportLayoutsAsFile", new Class[]{Long.TYPE, Boolean.TYPE, long[].class, Map.class, Date.class, Date.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutIds, parameterMap, startDate, endDate});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (File)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static byte[] exportPortletInfo(HttpPrincipal httpPrincipal, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "exportPortletInfo", new Class[]{Long.TYPE, Long.TYPE, String.class, Map.class, Date.class, Date.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid, groupId, portletId, parameterMap, startDate, endDate});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (byte[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static File exportPortletInfoAsFile(HttpPrincipal httpPrincipal, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "exportPortletInfoAsFile", new Class[]{Long.TYPE, Long.TYPE, String.class, Map.class, Date.class, Date.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid, groupId, portletId, parameterMap, startDate, endDate});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (File)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static String getLayoutName(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, String languageId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "getLayoutName", new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, languageId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (String)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static LayoutReference[] getLayoutReferences(HttpPrincipal httpPrincipal, long companyId, String portletId, String preferencesKey, String preferencesValue) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "getLayoutReferences", new Class[]{Long.TYPE, String.class, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, portletId, preferencesKey, preferencesValue});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (LayoutReference[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void importLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, byte[] bytes) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "importLayouts", new Class[]{Long.TYPE, Boolean.TYPE, Map.class, byte[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parameterMap, bytes});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void importLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "importLayouts", new Class[]{Long.TYPE, Boolean.TYPE, Map.class, File.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parameterMap, file});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void importLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, InputStream is) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "importLayouts", new Class[]{Long.TYPE, Boolean.TYPE, Map.class, InputStream.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parameterMap, is});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void importPortletInfo(HttpPrincipal httpPrincipal, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "importPortletInfo", new Class[]{Long.TYPE, Long.TYPE, String.class, Map.class, File.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid, groupId, portletId, parameterMap, file});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void importPortletInfo(HttpPrincipal httpPrincipal, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "importPortletInfo", new Class[]{Long.TYPE, Long.TYPE, String.class, Map.class, InputStream.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid, groupId, portletId, parameterMap, is});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void schedulePublishToLive(HttpPrincipal httpPrincipal, long sourceGroupId, long targetGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String scope, Date startDate, Date endDate, String groupName, String cronText, Date schedulerStartDate, Date schedulerEndDate, String description) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "schedulePublishToLive", new Class[]{Long.TYPE, Long.TYPE, Boolean.TYPE, Map.class, Map.class, String.class, Date.class, Date.class, String.class, String.class, Date.class, Date.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{sourceGroupId, targetGroupId, privateLayout, layoutIdMap, parameterMap, scope, startDate, endDate, groupName, cronText, schedulerStartDate, schedulerEndDate, description});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void schedulePublishToRemote(HttpPrincipal httpPrincipal, long sourceGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String remoteAddress, int remotePort, boolean secureConnection, long remoteGroupId, boolean remotePrivateLayout, Date startDate, Date endDate, String groupName, String cronText, Date schedulerStartDate, Date schedulerEndDate, String description) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "schedulePublishToRemote", new Class[]{Long.TYPE, Boolean.TYPE, Map.class, Map.class, String.class, Integer.TYPE, Boolean.TYPE, Long.TYPE, Boolean.TYPE, Date.class, Date.class, String.class, String.class, Date.class, Date.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{sourceGroupId, privateLayout, layoutIdMap, parameterMap, remoteAddress, remotePort, secureConnection, remoteGroupId, remotePrivateLayout, startDate, endDate, groupName, cronText, schedulerStartDate, schedulerEndDate, description});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long parentLayoutId, long[] layoutIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "setLayouts", new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parentLayoutId, layoutIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unschedulePublishToLive(HttpPrincipal httpPrincipal, long groupId, String jobName, String groupName) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "unschedulePublishToLive", new Class[]{Long.TYPE, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, jobName, groupName});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unschedulePublishToRemote(HttpPrincipal httpPrincipal, long groupId, String jobName, String groupName) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "unschedulePublishToRemote", new Class[]{Long.TYPE, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, jobName, groupName});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, String description, String type, boolean hidden, String friendlyURL, Boolean iconImage, byte[] iconBytes, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "updateLayout", new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE, Map.class, Map.class, String.class, String.class, Boolean.TYPE, String.class, Boolean.class, byte[].class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, parentLayoutId, localeNamesMap, localeTitlesMap, description, type, hidden, friendlyURL, iconImage, iconBytes, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, String description, String type, boolean hidden, String friendlyURL, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "updateLayout", new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE, Map.class, Map.class, String.class, String.class, Boolean.TYPE, String.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, parentLayoutId, localeNamesMap, localeTitlesMap, description, type, hidden, friendlyURL, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, String typeSettings) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "updateLayout", new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, typeSettings});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateLookAndFeel(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, String themeId, String colorSchemeId, String css, boolean wapTheme) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "updateLookAndFeel", new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, String.class, String.class, String.class, Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, themeId, colorSchemeId, css, wapTheme});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateName(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, String name, String languageId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "updateName", new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, name, languageId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateName(HttpPrincipal httpPrincipal, long plid, String name, String languageId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "updateName", new Class[]{Long.TYPE, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid, name, languageId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateParentLayoutId(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, long parentLayoutId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "updateParentLayoutId", new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, parentLayoutId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateParentLayoutId(HttpPrincipal httpPrincipal, long plid, long parentPlid) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "updateParentLayoutId", new Class[]{Long.TYPE, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid, parentPlid});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updatePriority(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, int priority) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "updatePriority", new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, priority});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updatePriority(HttpPrincipal httpPrincipal, long plid, int priority) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "updatePriority", new Class[]{Long.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid, priority});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

