/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.UserPasswordException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.security.pwd.BasicToolkit;
import com.liferay.portal.util.PropsUtil;

public class PwdToolkitUtil {
    private static PwdToolkitUtil _instance = new PwdToolkitUtil();
    private BasicToolkit _toolkit = (BasicToolkit)InstancePool.get((String)PropsUtil.get("passwords.toolkit"));

    public static String generate(PasswordPolicy passwordPolicy) {
        return _instance._generate(passwordPolicy);
    }

    public static void validate(long companyId, long userId, String password1, String password2, PasswordPolicy passwordPolicy) throws PortalException, SystemException {
        if (!password1.equals(password2)) {
            throw new UserPasswordException(10);
        }
        if (!LDAPSettingsUtil.isPasswordPolicyEnabled(companyId)) {
            _instance._validate(userId, password1, password2, passwordPolicy);
        }
    }

    private PwdToolkitUtil() {
    }

    private String _generate(PasswordPolicy passwordPolicy) {
        return this._toolkit.generate(passwordPolicy);
    }

    private void _validate(long userId, String password1, String password2, PasswordPolicy passwordPolicy) throws PortalException, SystemException {
        this._toolkit.validate(userId, password1, password2, passwordPolicy);
    }
}

