/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.security.auth.ScreenNameGenerator;
import com.liferay.portal.util.PropsValues;

public class ScreenNameGeneratorFactory {
    private static Log _log = LogFactoryUtil.getLog(ScreenNameGeneratorFactory.class);
    private static ScreenNameGenerator _screenNameGenerator;

    public static ScreenNameGenerator getInstance() {
        if (_screenNameGenerator == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Instantiate " + PropsValues.USERS_SCREEN_NAME_GENERATOR));
            }
            ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
            try {
                _screenNameGenerator = (ScreenNameGenerator)classLoader.loadClass(PropsValues.USERS_SCREEN_NAME_GENERATOR).newInstance();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Return " + _screenNameGenerator.getClass().getName()));
        }
        return _screenNameGenerator;
    }

    public static void setInstance(ScreenNameGenerator screenNameGenerator) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Set " + screenNameGenerator.getClass().getName()));
        }
        _screenNameGenerator = screenNameGenerator;
    }
}

