/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.PasswordExpiredException;
import com.liferay.portal.UserLockoutException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AuthException;
import com.liferay.portal.security.auth.Authenticator;
import com.liferay.portal.security.auth.LDAPAuthResult;
import com.liferay.portal.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.security.ldap.PortalLDAPImporterUtil;
import com.liferay.portal.security.ldap.PortalLDAPUtil;
import com.liferay.portal.security.pwd.PwdEncryptor;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.admin.util.OmniadminUtil;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPAuth
implements Authenticator {
    public static final String AUTH_METHOD_BIND = "bind";
    public static final String AUTH_METHOD_PASSWORD_COMPARE = "password-compare";
    public static final String RESULT_PASSWORD_EXP_WARNING = "2.16.840.1.113730.3.4.5";
    public static final String RESULT_PASSWORD_RESET = "2.16.840.1.113730.3.4.4";
    private static Log _log = LogFactoryUtil.getLog(LDAPAuth.class);

    public int authenticateByEmailAddress(long companyId, String emailAddress, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        try {
            return this.authenticate(companyId, emailAddress, "", 0L, password);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new AuthException((Throwable)e);
        }
    }

    public int authenticateByScreenName(long companyId, String screenName, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        try {
            return this.authenticate(companyId, "", screenName, 0L, password);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new AuthException((Throwable)e);
        }
    }

    public int authenticateByUserId(long companyId, long userId, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        try {
            return this.authenticate(companyId, "", "", userId, password);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new AuthException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected LDAPAuthResult authenticate(LdapContext ctx, long companyId, Attributes attributes, String userDN, String password) throws Exception {
        LDAPAuthResult ldapAuthResult = new LDAPAuthResult();
        String authMethod = PrefsPropsUtil.getString(companyId, "ldap.auth.method");
        InitialContext innerCtx = null;
        if (authMethod.equals(AUTH_METHOD_BIND)) {
            try {
                try {
                    Hashtable<?, ?> env = ctx.getEnvironment();
                    env.put("java.naming.security.principal", userDN);
                    env.put("java.naming.security.credentials", password);
                    env.put("java.naming.referral", PrefsPropsUtil.getString(companyId, "ldap.referral"));
                    env.put("com.sun.jndi.ldap.connect.pool", "false");
                    innerCtx = new InitialLdapContext(env, null);
                    Control[] responseControls = ((InitialLdapContext)innerCtx).getResponseControls();
                    ldapAuthResult.setAuthenticated(true);
                    ldapAuthResult.setResponseControl(responseControls);
                    return ldapAuthResult;
                }
                catch (Exception e) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Failed to bind to the LDAP server with userDN " + userDN + " and password " + password));
                    }
                    _log.error((Object)"Failed to bind to the LDAP server", (Throwable)e);
                    ldapAuthResult.setAuthenticated(false);
                    ldapAuthResult.setErrorMessage(e.getMessage());
                    if (innerCtx == null) return ldapAuthResult;
                    innerCtx.close();
                }
                return ldapAuthResult;
            }
            finally {
                if (innerCtx != null) {
                    innerCtx.close();
                }
            }
        } else {
            Attribute userPassword;
            if (!authMethod.equals(AUTH_METHOD_PASSWORD_COMPARE) || (userPassword = attributes.get("userPassword")) == null) return ldapAuthResult;
            String ldapPassword = new String((byte[])userPassword.get());
            String encryptedPassword = password;
            String algorithm = PrefsPropsUtil.getString(companyId, "ldap.auth.password.encryption.algorithm");
            if (Validator.isNotNull((String)algorithm)) {
                encryptedPassword = "{" + algorithm + "}" + PwdEncryptor.encrypt(algorithm, password, ldapPassword);
            }
            if (ldapPassword.equals(encryptedPassword)) {
                ldapAuthResult.setAuthenticated(true);
                return ldapAuthResult;
            } else {
                ldapAuthResult.setAuthenticated(false);
                if (!_log.isWarnEnabled()) return ldapAuthResult;
                _log.warn((Object)("Passwords do not match for userDN " + userDN));
            }
        }
        return ldapAuthResult;
    }

    protected int authenticate(long companyId, long ldapServerId, String emailAddress, String screenName, long userId, String password) throws Exception {
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        LdapContext ldapContext = PortalLDAPUtil.getContext(ldapServerId, companyId);
        if (ldapContext == null) {
            return -1;
        }
        try {
            String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
            String filter = LDAPSettingsUtil.getAuthSearchFilter(ldapServerId, companyId, emailAddress, screenName, String.valueOf(userId));
            Properties userMappings = LDAPSettingsUtil.getUserMappings(ldapServerId, companyId);
            String userMappingsScreenName = GetterUtil.getString((String)userMappings.getProperty("screenName")).toLowerCase();
            SearchControls searchControls = new SearchControls(2, 1L, 0, new String[]{userMappingsScreenName}, false, false);
            NamingEnumeration<SearchResult> enu = ldapContext.search(baseDN, filter, searchControls);
            if (enu.hasMoreElements()) {
                SearchResult result;
                String fullUserDN;
                Attributes attributes;
                LDAPAuthResult ldapAuthResult;
                String errorMessage;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Search filter returned at least one result");
                }
                if ((errorMessage = (ldapAuthResult = this.authenticate(ldapContext, companyId, attributes = PortalLDAPUtil.getUserAttributes(ldapServerId, companyId, ldapContext, fullUserDN = PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, result = (SearchResult)enu.nextElement())), fullUserDN, password)).getErrorMessage()) != null) {
                    if (errorMessage.indexOf(PrefsPropsUtil.getString(companyId, "ldap.error.user.lockout")) != -1) {
                        throw new UserLockoutException();
                    }
                    if (errorMessage.indexOf(PrefsPropsUtil.getString(companyId, "ldap.error.password.expired")) != -1) {
                        throw new PasswordExpiredException();
                    }
                }
                if (!ldapAuthResult.isAuthenticated()) {
                    return -1;
                }
                User user = PortalLDAPImporterUtil.importLDAPUser(ldapServerId, companyId, ldapContext, attributes, password);
                String resultCode = ldapAuthResult.getResponseControl();
                if (resultCode.equals(RESULT_PASSWORD_RESET)) {
                    UserLocalServiceUtil.updatePasswordReset((long)user.getUserId(), (boolean)true);
                } else if (resultCode.equals(RESULT_PASSWORD_EXP_WARNING)) {
                    UserLocalServiceUtil.updatePasswordReset((long)user.getUserId(), (boolean)true);
                }
            } else {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Search filter did not return any results");
                }
                return 0;
            }
            try {
                enu.close();
            }
            catch (Exception e) {
                _log.error((Object)"Problem accessing LDAP server", (Throwable)e);
                return -1;
            }
        }
        finally {
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
        return 1;
    }

    protected int authenticate(long companyId, String emailAddress, String screenName, long userId, String password) throws Exception {
        long[] ldapServerIds;
        if (!LDAPSettingsUtil.isAuthEnabled(companyId)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Authenticator is not enabled");
            }
            return 1;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Authenticator is enabled");
        }
        if ((ldapServerIds = StringUtil.split((String)PrefsPropsUtil.getString(companyId, "ldap.server.ids"), (long)0L)).length <= 0) {
            ldapServerIds = new long[1];
        }
        long[] lArray = ldapServerIds;
        int n = ldapServerIds.length;
        int n2 = 0;
        while (n2 < n) {
            long ldapServerId = lArray[n2];
            int result = this.authenticate(companyId, ldapServerId, emailAddress, screenName, userId, password);
            if (result == 1) {
                return result;
            }
            ++n2;
        }
        return this.authenticateRequired(companyId, userId, emailAddress, screenName, true, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int authenticateOmniadmin(long companyId, String emailAddress, String screenName, long userId) throws Exception {
        if (!PropsValues.AUTH_PIPELINE_ENABLE_LIFERAY_CHECK) return -1;
        if (userId > 0L) {
            if (!OmniadminUtil.isOmniadmin(userId)) return -1;
            return 1;
        }
        if (Validator.isNotNull((String)emailAddress)) {
            try {
                User user = UserLocalServiceUtil.getUserByEmailAddress((long)companyId, (String)emailAddress);
                if (!OmniadminUtil.isOmniadmin(user.getUserId())) return -1;
                return 1;
            }
            catch (NoSuchUserException noSuchUserException) {
                return -1;
            }
        } else {
            if (!Validator.isNotNull((String)screenName)) return -1;
            try {
                User user = UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)screenName);
                if (!OmniadminUtil.isOmniadmin(user.getUserId())) return -1;
                return 1;
            }
            catch (NoSuchUserException noSuchUserException) {}
        }
        return -1;
    }

    protected int authenticateRequired(long companyId, long userId, String emailAddress, String screenName, boolean allowOmniadmin, int failureCode) throws Exception {
        if (allowOmniadmin && this.authenticateOmniadmin(companyId, emailAddress, screenName, userId) == 1) {
            return 1;
        }
        if (PrefsPropsUtil.getBoolean(companyId, "ldap.auth.required")) {
            return failureCode;
        }
        return 1;
    }
}

