/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.lucene.IndexAccessor;
import com.liferay.portal.search.lucene.IndexAccessorImpl;
import com.liferay.portal.search.lucene.LuceneHelper;
import com.liferay.portal.util.PropsUtil;
import com.liferay.util.lucene.KeywordsUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.QueryTermExtractor;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.WeightedTerm;
import org.apache.lucene.util.Version;

public class LuceneHelperImpl
implements LuceneHelper {
    private static Log _log = LogFactoryUtil.getLog(LuceneHelperImpl.class);
    private Class<?> _analyzerClass = WhitespaceAnalyzer.class;
    private Map<Long, IndexAccessor> _indexAccessorMap = new ConcurrentHashMap<Long, IndexAccessor>();
    private Version _version = Version.LUCENE_24;

    public void addDocument(long companyId, Document document) throws IOException {
        IndexAccessor indexAccessor = this._getIndexAccessor(companyId);
        indexAccessor.addDocument(document);
    }

    public void addExactTerm(BooleanQuery booleanQuery, String field, String value) {
        TermQuery query = new TermQuery(new Term(field, value));
        booleanQuery.add((Query)query, BooleanClause.Occur.SHOULD);
    }

    public void addRequiredTerm(BooleanQuery booleanQuery, String field, String value, boolean like) {
        if (like) {
            value = StringUtil.replace((String)value, (String)"%", (String)"*");
            value = value.toLowerCase();
            WildcardQuery wildcardQuery = new WildcardQuery(new Term(field, value));
            booleanQuery.add((Query)wildcardQuery, BooleanClause.Occur.MUST);
        } else {
            Term term = new Term(field, value);
            TermQuery termQuery = new TermQuery(term);
            booleanQuery.add((Query)termQuery, BooleanClause.Occur.MUST);
        }
    }

    public void addTerm(BooleanQuery booleanQuery, String field, String value, boolean like) throws ParseException {
        if (Validator.isNull((String)value)) {
            return;
        }
        if (like) {
            value = StringUtil.replace((String)value, (String)"%", (String)"");
            value = value.toLowerCase();
            Term term = new Term(field, "*".concat(value).concat("*"));
            WildcardQuery wildcardQuery = new WildcardQuery(term);
            booleanQuery.add((Query)wildcardQuery, BooleanClause.Occur.SHOULD);
        } else {
            QueryParser queryParser = new QueryParser(this._version, field, this.getAnalyzer());
            try {
                Query query = queryParser.parse(value);
                booleanQuery.add(query, BooleanClause.Occur.SHOULD);
            }
            catch (ParseException pe) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"ParseException thrown, reverting to literal search", (Throwable)pe);
                }
                value = KeywordsUtil.escape((String)value);
                Query query = queryParser.parse(value);
                booleanQuery.add(query, BooleanClause.Occur.SHOULD);
            }
        }
    }

    public void delete(long companyId) {
        IndexAccessor indexAccessor = this._getIndexAccessor(companyId);
        indexAccessor.delete();
    }

    public void deleteDocuments(long companyId, Term term) throws IOException {
        IndexAccessor indexAccessor = this._getIndexAccessor(companyId);
        indexAccessor.deleteDocuments(term);
    }

    public Analyzer getAnalyzer() {
        try {
            return (Analyzer)this._analyzerClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String[] getQueryTerms(Query query) {
        String[] fieldNames = new String[]{"content", "description", "properties", "title", "userName"};
        WeightedTerm[] weightedTerms = null;
        String[] stringArray = fieldNames;
        int n = fieldNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            weightedTerms = QueryTermExtractor.getTerms((Query)query, (boolean)false, (String)fieldName);
            if (weightedTerms.length > 0) break;
            ++n2;
        }
        HashSet<String> queryTerms = new HashSet<String>();
        WeightedTerm[] weightedTermArray = weightedTerms;
        int n3 = weightedTerms.length;
        n = 0;
        while (n < n3) {
            WeightedTerm weightedTerm = weightedTermArray[n];
            queryTerms.add(weightedTerm.getTerm());
            ++n;
        }
        return queryTerms.toArray(new String[queryTerms.size()]);
    }

    public IndexSearcher getSearcher(long companyId, boolean readOnly) throws IOException {
        IndexAccessor indexAccessor = this._getIndexAccessor(companyId);
        return new IndexSearcher(indexAccessor.getLuceneDir(), readOnly);
    }

    public String getSnippet(Query query, String field, String s, int maxNumFragments, int fragmentLength, String fragmentSuffix, String preTag, String postTag) throws IOException {
        SimpleHTMLFormatter simpleHTMLFormatter = new SimpleHTMLFormatter(preTag, postTag);
        QueryScorer queryScorer = new QueryScorer(query, field);
        Highlighter highlighter = new Highlighter((Formatter)simpleHTMLFormatter, (Scorer)queryScorer);
        highlighter.setTextFragmenter((Fragmenter)new SimpleFragmenter(fragmentLength));
        TokenStream tokenStream = this.getAnalyzer().tokenStream(field, (Reader)new UnsyncStringReader(s));
        try {
            String snippet = highlighter.getBestFragments(tokenStream, s, maxNumFragments, fragmentSuffix);
            if (Validator.isNotNull((String)snippet) && !StringUtil.endsWith((String)snippet, (String)fragmentSuffix)) {
                snippet = String.valueOf(snippet) + fragmentSuffix;
            }
            return snippet;
        }
        catch (InvalidTokenOffsetsException itoe) {
            throw new IOException(itoe.getMessage());
        }
    }

    public Version getVersion() {
        return this._version;
    }

    public void updateDocument(long companyId, Term term, Document document) throws IOException {
        IndexAccessor indexAccessor = this._getIndexAccessor(companyId);
        indexAccessor.updateDocument(term, document);
    }

    public void shutdown() {
        for (IndexAccessor indexAccessor : this._indexAccessorMap.values()) {
            indexAccessor.close();
        }
    }

    private LuceneHelperImpl() {
        String analyzerName = PropsUtil.get("lucene.analyzer");
        if (Validator.isNotNull((String)analyzerName)) {
            try {
                this._analyzerClass = Class.forName(analyzerName);
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexAccessor _getIndexAccessor(long companyId) {
        IndexAccessor indexAccessor = this._indexAccessorMap.get(companyId);
        if (indexAccessor == null) {
            LuceneHelperImpl luceneHelperImpl = this;
            synchronized (luceneHelperImpl) {
                indexAccessor = this._indexAccessorMap.get(companyId);
                if (indexAccessor == null) {
                    indexAccessor = new IndexAccessorImpl(companyId);
                    this._indexAccessorMap.put(companyId, indexAccessor);
                }
            }
        }
        return indexAccessor;
    }
}

