/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler.quartz;

import com.liferay.portal.dao.db.DB2DB;
import com.liferay.portal.dao.db.HypersonicDB;
import com.liferay.portal.dao.db.PostgreSQLDB;
import com.liferay.portal.dao.db.SQLServerDB;
import com.liferay.portal.dao.db.SybaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import org.quartz.impl.jdbcjobstore.DB2v8Delegate;
import org.quartz.impl.jdbcjobstore.DriverDelegate;
import org.quartz.impl.jdbcjobstore.HSQLDBDelegate;
import org.quartz.impl.jdbcjobstore.JobStoreTX;
import org.quartz.impl.jdbcjobstore.MSSQLDelegate;
import org.quartz.impl.jdbcjobstore.NoSuchDelegateException;
import org.quartz.impl.jdbcjobstore.PostgreSQLDelegate;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;

public class PortalJobStore
extends JobStoreTX {
    private static Log _log = LogFactoryUtil.getLog(PortalJobStore.class);
    private DriverDelegate _driverDelegate;

    protected DriverDelegate getDelegate() throws NoSuchDelegateException {
        if (this._driverDelegate != null) {
            return this._driverDelegate;
        }
        try {
            Class<StdJDBCDelegate> driverDelegateClass = StdJDBCDelegate.class;
            DB db = DBFactoryUtil.getDB();
            if (db instanceof DB2DB) {
                driverDelegateClass = DB2v8Delegate.class;
            } else if (db instanceof HypersonicDB) {
                driverDelegateClass = HSQLDBDelegate.class;
            } else if (db instanceof PostgreSQLDB) {
                driverDelegateClass = PostgreSQLDelegate.class;
            } else if (db instanceof SQLServerDB) {
                driverDelegateClass = MSSQLDelegate.class;
            } else if (db instanceof SybaseDB) {
                driverDelegateClass = MSSQLDelegate.class;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Instantiating " + driverDelegateClass));
            }
            this.setDriverDelegateClass(driverDelegateClass.getName());
            this._driverDelegate = super.getDelegate();
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Using driver delegate " + this._driverDelegate.getClass().getName()));
            }
            return this._driverDelegate;
        }
        catch (NoSuchDelegateException nsde) {
            throw nsde;
        }
        catch (Exception e) {
            throw new NoSuchDelegateException(e.getMessage());
        }
    }
}

