/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.poller;

import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.poller.PollerHeader;
import com.liferay.portal.kernel.poller.PollerProcessor;
import com.liferay.portal.kernel.poller.PollerRequest;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BrowserTracker;
import com.liferay.portal.model.Company;
import com.liferay.portal.poller.PollerProcessorUtil;
import com.liferay.portal.poller.PollerRequestManager;
import com.liferay.portal.service.BrowserTrackerLocalServiceUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.Encryptor;
import com.liferay.util.servlet.ServletResponseUtil;
import java.io.IOException;
import java.security.Key;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollerServlet
extends HttpServlet {
    private static final String _ESCAPED_CLOSE_CURLY_BRACE = "[$CLOSE_CURLY_BRACE$]";
    private static final String _ESCAPED_OPEN_CURLY_BRACE = "[$OPEN_CURLY_BRACE$]";
    private static final String _OPEN_HASH_MAP_WRAPPER = "{\"javaClass\":\"java.util.HashMap\",\"map\":{";
    private static final String _PATH_RECEIVE = "/receive";
    private static Log _log = LogFactoryUtil.getLog(PollerServlet.class);

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            String content = this.getContent(request);
            if (content == null) {
                PortalUtil.sendError((int)404, (Exception)((Object)new NoSuchLayoutException()), (HttpServletRequest)request, (HttpServletResponse)response);
            } else {
                response.setContentType("text/plain; charset=UTF-8");
                ServletResponseUtil.write((HttpServletResponse)response, (byte[])content.getBytes("UTF-8"));
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            PortalUtil.sendError((int)500, (Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    protected String getContent(HttpServletRequest request) throws Exception {
        String pollerRequestString = this.getPollerRequestString(request);
        if (Validator.isNull((String)pollerRequestString)) {
            return null;
        }
        Map[] pollerRequestChunks = (Map[])JSONFactoryUtil.deserialize((String)pollerRequestString);
        PollerHeader pollerHeader = this.getPollerHeader(pollerRequestChunks);
        if (pollerHeader == null) {
            return null;
        }
        boolean receiveRequest = this.isReceiveRequest(request);
        JSONArray pollerResponseChunksJSON = null;
        HashSet<String> portletIdsWithChunks = null;
        if (receiveRequest) {
            pollerResponseChunksJSON = JSONFactoryUtil.createJSONArray();
            portletIdsWithChunks = new HashSet<String>();
            boolean suspendPolling = false;
            if (pollerHeader.isStartPolling()) {
                BrowserTrackerLocalServiceUtil.updateBrowserTracker((long)pollerHeader.getUserId(), (long)pollerHeader.getBrowserKey());
            } else {
                BrowserTracker browserTracker = BrowserTrackerLocalServiceUtil.getBrowserTracker((long)pollerHeader.getUserId(), (long)pollerHeader.getBrowserKey());
                if (browserTracker.getBrowserKey() != pollerHeader.getBrowserKey()) {
                    suspendPolling = true;
                }
            }
            JSONObject pollerResponseChunkJSON = JSONFactoryUtil.createJSONObject();
            pollerResponseChunkJSON.put("userId", pollerHeader.getUserId());
            pollerResponseChunkJSON.put("initialRequest", pollerHeader.isInitialRequest());
            pollerResponseChunkJSON.put("suspendPolling", suspendPolling);
            pollerResponseChunksJSON.put(pollerResponseChunkJSON);
        }
        PollerRequestManager pollerRequestManager = new PollerRequestManager(pollerResponseChunksJSON, "liferay/poller", "liferay/poller_response", PropsValues.POLLER_REQUEST_TIMEOUT);
        int i = 1;
        while (i < pollerRequestChunks.length) {
            Map pollerRequestChunk = pollerRequestChunks[i];
            String portletId = (String)pollerRequestChunk.get("portletId");
            Map<String, String> parameterMap = this.getData(pollerRequestChunk);
            String chunkId = (String)pollerRequestChunk.get("chunkId");
            try {
                PollerRequest pollerRequest = this.process(portletIdsWithChunks, pollerHeader, portletId, parameterMap, chunkId, receiveRequest);
                pollerRequestManager.addPollerRequest(pollerRequest);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            ++i;
        }
        pollerRequestManager.processRequests();
        if (!receiveRequest) {
            return "";
        }
        pollerRequestManager.clearRequests();
        String[] stringArray = pollerHeader.getPortletIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String portletId = stringArray[n2];
            if (!portletIdsWithChunks.contains(portletId)) {
                try {
                    PollerRequest pollerRequest = this.process(portletIdsWithChunks, pollerHeader, portletId, new HashMap<String, String>(), null, receiveRequest);
                    pollerRequestManager.addPollerRequest(pollerRequest);
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
            }
            ++n2;
        }
        pollerRequestManager.processRequests();
        pollerResponseChunksJSON = pollerRequestManager.getPollerResponse();
        return pollerResponseChunksJSON.toString();
    }

    protected Map<String, String> getData(Map<String, Object> pollerRequestChunk) throws Exception {
        Map oldParameterMap = (Map)pollerRequestChunk.get("data");
        HashMap<String, String> newParameterMap = new HashMap<String, String>();
        if (oldParameterMap == null) {
            return newParameterMap;
        }
        for (Map.Entry entry : oldParameterMap.entrySet()) {
            newParameterMap.put((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        return newParameterMap;
    }

    protected PollerHeader getPollerHeader(Map<String, Object>[] pollerRequestChunks) throws Exception {
        if (pollerRequestChunks.length < 1) {
            return null;
        }
        Map<String, Object> pollerRequestChunk = pollerRequestChunks[0];
        long companyId = GetterUtil.getLong((String)String.valueOf(pollerRequestChunk.get("companyId")));
        String userIdString = GetterUtil.getString((String)String.valueOf(pollerRequestChunk.get("userId")));
        long browserKey = GetterUtil.getLong((String)String.valueOf(pollerRequestChunk.get("browserKey")));
        String[] portletIds = StringUtil.split((String)String.valueOf(pollerRequestChunk.get("portletIds")));
        boolean initialRequest = GetterUtil.getBoolean((String)String.valueOf(pollerRequestChunk.get("initialRequest")));
        boolean startPolling = GetterUtil.getBoolean((String)String.valueOf(pollerRequestChunk.get("startPolling")));
        long userId = this.getUserId(companyId, userIdString);
        if (userId == 0L) {
            return null;
        }
        return new PollerHeader(companyId, userId, browserKey, portletIds, initialRequest, startPolling);
    }

    protected String getPollerRequestString(HttpServletRequest request) throws Exception {
        String pollerRequestString = ParamUtil.getString((HttpServletRequest)request, (String)"pollerRequest");
        if (Validator.isNull((String)pollerRequestString)) {
            return null;
        }
        return StringUtil.replace((String)pollerRequestString, (String[])new String[]{"{", "}", _ESCAPED_OPEN_CURLY_BRACE, _ESCAPED_CLOSE_CURLY_BRACE}, (String[])new String[]{_OPEN_HASH_MAP_WRAPPER, "}}", "{", "}"});
    }

    protected long getUserId(long companyId, String userIdString) {
        long userId = 0L;
        try {
            Company company = CompanyLocalServiceUtil.getCompany((long)companyId);
            userId = GetterUtil.getLong((String)Encryptor.decrypt((Key)company.getKeyObj(), (String)userIdString));
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid credentials for company id " + companyId + " and user id " + userIdString));
        }
        return userId;
    }

    protected boolean isReceiveRequest(HttpServletRequest request) throws Exception {
        String path = GetterUtil.getString((String)request.getPathInfo());
        return path.endsWith(_PATH_RECEIVE);
    }

    protected PollerRequest process(Set<String> portletIdsWithChunks, PollerHeader pollerHeader, String portletId, Map<String, String> parameterMap, String chunkId, boolean receiveRequest) throws Exception {
        PollerProcessor pollerProcessor = PollerProcessorUtil.getPollerProcessor(portletId);
        if (pollerProcessor == null) {
            _log.error((Object)("Poller processor not found for portlet " + portletId));
            return null;
        }
        PollerRequest pollerRequest = new PollerRequest(pollerHeader, portletId, parameterMap, chunkId, receiveRequest);
        if (receiveRequest) {
            portletIdsWithChunks.add(portletId);
        }
        return pollerRequest;
    }
}

