/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.plugin;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.plugin.PluginPackageException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryReport {
    public static final String SUCCESS = "success";
    private Map<String, String> _reportMap = new TreeMap<String, String>();

    public void addSuccess(String repositoryURL) {
        this._reportMap.put(repositoryURL, SUCCESS);
    }

    public void addError(String repositoryURL, PluginPackageException ppe) {
        StringBundler sb = new StringBundler(3);
        if (Validator.isNotNull((String)ppe.getMessage())) {
            sb.append(ppe.getMessage());
        }
        if (ppe.getCause() != null && Validator.isNull((String)ppe.getCause().getMessage())) {
            sb.append(ppe.getCause().getMessage());
        }
        if (sb.length() == 0) {
            sb.append(ppe.toString());
        }
        this._reportMap.put(repositoryURL, sb.toString());
    }

    public Set<String> getRepositoryURLs() {
        return this._reportMap.keySet();
    }

    public String getState(String repositoryURL) {
        return this._reportMap.get(repositoryURL);
    }

    public String toString() {
        Iterator<String> itr = this.getRepositoryURLs().iterator();
        if (this.getRepositoryURLs().isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(this.getRepositoryURLs().size() * 3);
        while (itr.hasNext()) {
            String repositoryURL = itr.next();
            sb.append(repositoryURL);
            sb.append(": ");
            sb.append(this._reportMap.get(repositoryURL));
        }
        return sb.toString();
    }
}

