/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model;

import com.liferay.portal.ModelListenerException;
import com.liferay.portal.model.BaseModelListener;
import com.liferay.portal.model.Contact;
import com.liferay.portal.security.ldap.LDAPUserTransactionThreadLocal;
import com.liferay.portal.security.ldap.PortalLDAPExporterUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import java.io.Serializable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactListener
extends BaseModelListener<Contact> {
    public void onAfterCreate(Contact contact) throws ModelListenerException {
        try {
            this.exportToLDAP(contact);
        }
        catch (Exception e) {
            throw new ModelListenerException((Throwable)e);
        }
    }

    public void onAfterUpdate(Contact contact) throws ModelListenerException {
        try {
            this.exportToLDAP(contact);
        }
        catch (Exception e) {
            throw new ModelListenerException((Throwable)e);
        }
    }

    protected void exportToLDAP(Contact contact) throws Exception {
        if (LDAPUserTransactionThreadLocal.isOriginatesFromLDAP()) {
            return;
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Map expandoBridgeAttributes = null;
        if (serviceContext != null) {
            expandoBridgeAttributes = serviceContext.getExpandoBridgeAttributes();
        }
        PortalLDAPExporterUtil.exportToLDAP(contact, (Map<String, Serializable>)expandoBridgeAttributes);
    }
}

