/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.editor.fckeditor.receiver.impl;

import com.liferay.portal.editor.fckeditor.command.CommandArgument;
import com.liferay.portal.editor.fckeditor.exception.FCKException;
import com.liferay.portal.editor.fckeditor.receiver.impl.BaseCommandReceiver;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import com.liferay.portlet.documentlibrary.service.DLFileEntryServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderServiceUtil;
import java.io.File;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DocumentCommandReceiver
extends BaseCommandReceiver {
    protected String createFolder(CommandArgument arg) {
        try {
            Group group = arg.getCurrentGroup();
            DLFolder folder = this._getFolder(group.getGroupId(), "/" + arg.getCurrentFolder());
            long parentFolderId = folder.getFolderId();
            String name = arg.getNewFolder();
            String description = "";
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddCommunityPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            DLFolderServiceUtil.addFolder((long)group.getGroupId(), (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
        }
        catch (Exception e) {
            throw new FCKException(e);
        }
        return "0";
    }

    protected String fileUpload(CommandArgument arg, String fileName, File file, String extension) {
        try {
            Group group = arg.getCurrentGroup();
            DLFolder folder = this._getFolder(group.getGroupId(), arg.getCurrentFolder());
            long folderId = folder.getFolderId();
            String name = fileName;
            String title = fileName;
            String description = "";
            String changeLog = "";
            String extraSettings = "";
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddCommunityPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            DLFileEntryServiceUtil.addFileEntry((long)group.getGroupId(), (long)folderId, (String)name, (String)title, (String)description, (String)changeLog, (String)extraSettings, (File)file, (ServiceContext)serviceContext);
        }
        catch (Exception e) {
            throw new FCKException(e);
        }
        return "0";
    }

    protected void getFolders(CommandArgument arg, Document doc, Node root) {
        try {
            this._getFolders(arg, doc, root);
        }
        catch (Exception e) {
            throw new FCKException(e);
        }
    }

    protected void getFoldersAndFiles(CommandArgument arg, Document doc, Node root) {
        try {
            this._getFolders(arg, doc, root);
            this._getFiles(arg, doc, root);
        }
        catch (Exception e) {
            throw new FCKException(e);
        }
    }

    private void _getFiles(CommandArgument arg, Document doc, Node root) throws Exception {
        Element filesEl = doc.createElement("Files");
        root.appendChild(filesEl);
        if (Validator.isNull((String)arg.getCurrentGroupName())) {
            return;
        }
        Group group = arg.getCurrentGroup();
        DLFolder folder = this._getFolder(group.getGroupId(), arg.getCurrentFolder());
        List fileEntries = DLFileEntryServiceUtil.getFileEntries((long)folder.getGroupId(), (long)folder.getFolderId());
        for (DLFileEntry fileEntry : fileEntries) {
            Element fileEl = doc.createElement("File");
            filesEl.appendChild(fileEl);
            fileEl.setAttribute("name", fileEntry.getTitle());
            fileEl.setAttribute("desc", fileEntry.getTitle());
            fileEl.setAttribute("size", this.getSize(fileEntry.getSize()));
            StringBundler url = new StringBundler(5);
            ThemeDisplay themeDisplay = arg.getThemeDisplay();
            url.append(themeDisplay.getPathMain());
            url.append("/document_library/get_file?uuid=");
            url.append(fileEntry.getUuid());
            url.append("&groupId=");
            url.append(folder.getGroupId());
            fileEl.setAttribute("url", url.toString());
        }
    }

    private DLFolder _getFolder(long groupId, String folderName) throws Exception {
        DLFolderImpl folder = new DLFolderImpl();
        folder.setFolderId(0L);
        folder.setGroupId(groupId);
        if (folderName.equals("/")) {
            return folder;
        }
        StringTokenizer st = new StringTokenizer(folderName, "/");
        block0: while (st.hasMoreTokens()) {
            String curFolderName = st.nextToken();
            List folders = DLFolderServiceUtil.getFolders((long)groupId, (long)folder.getFolderId());
            for (DLFolder curFolder : folders) {
                if (!curFolder.getName().equals(curFolderName)) continue;
                folder = curFolder;
                continue block0;
            }
        }
        return folder;
    }

    private void _getFolders(CommandArgument arg, Document doc, Node root) throws Exception {
        Element foldersEl = doc.createElement("Folders");
        root.appendChild(foldersEl);
        if (arg.getCurrentFolder().equals("/")) {
            this.getRootFolders(arg, doc, foldersEl);
        } else {
            Group group = arg.getCurrentGroup();
            DLFolder folder = this._getFolder(group.getGroupId(), arg.getCurrentFolder());
            List folders = DLFolderServiceUtil.getFolders((long)group.getGroupId(), (long)folder.getFolderId());
            for (DLFolder curFolder : folders) {
                Element folderEl = doc.createElement("Folder");
                foldersEl.appendChild(folderEl);
                folderEl.setAttribute("name", curFolder.getName());
            }
        }
    }
}

