/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.plugin.PluginPackageImpl;
import com.liferay.portal.plugin.PluginPackageUtil;
import com.liferay.portal.service.ServiceComponentLocalServiceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;

public class PluginPackageHotDeployListener
extends BaseHotDeployListener {
    private static Log _log = LogFactoryUtil.getLog(PluginPackageHotDeployListener.class);

    public static PluginPackage readPluginPackage(ServletContext servletContext) throws DocumentException, IOException {
        PluginPackage pluginPackage = null;
        String servletContextName = servletContext.getServletContextName();
        String xml = HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-plugin-package.xml"));
        if (_log.isInfoEnabled()) {
            if (servletContextName == null) {
                _log.info((Object)"Reading plugin package for the root context");
            } else {
                _log.info((Object)("Reading plugin package for " + servletContextName));
            }
        }
        if (xml == null) {
            String pageURL;
            String version;
            String artifactId;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Reading plugin package from MANIFEST.MF");
            }
            Attributes attributes = null;
            InputStream is = servletContext.getResourceAsStream("/META-INF/MANIFEST.MF");
            if (is != null) {
                Manifest manifest = new Manifest(is);
                attributes = manifest.getMainAttributes();
            } else {
                attributes = new Attributes();
            }
            String artifactGroupId = attributes.getValue("Implementation-Vendor-Id");
            if (Validator.isNull((String)artifactGroupId)) {
                artifactGroupId = attributes.getValue("Implementation-Vendor");
            }
            if (Validator.isNull((String)artifactGroupId)) {
                artifactGroupId = GetterUtil.getString((String)attributes.getValue("Bundle-Vendor"), (String)servletContextName);
            }
            if (Validator.isNull((String)(artifactId = attributes.getValue("Implementation-Title")))) {
                artifactId = GetterUtil.getString((String)attributes.getValue("Bundle-Name"), (String)servletContextName);
            }
            if (Validator.isNull((String)(version = attributes.getValue("Implementation-Version")))) {
                version = GetterUtil.getString((String)attributes.getValue("Bundle-Version"), (String)"unknown");
            }
            if (version.equals("unknown") && _log.isWarnEnabled()) {
                _log.warn((Object)("Plugin package on context " + servletContextName + " cannot be tracked because this WAR does not " + "contain a liferay-plugin-package.xml file"));
            }
            pluginPackage = new PluginPackageImpl(String.valueOf(artifactGroupId) + "/" + artifactId + "/" + version + "/" + "war");
            pluginPackage.setName(artifactId);
            String shortDescription = attributes.getValue("Bundle-Description");
            if (Validator.isNotNull((String)shortDescription)) {
                pluginPackage.setShortDescription(shortDescription);
            }
            if (Validator.isNotNull((String)(pageURL = attributes.getValue("Bundle-DocURL")))) {
                pluginPackage.setPageURL(pageURL);
            }
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Reading plugin package from liferay-plugin-package.xml");
            }
            pluginPackage = PluginPackageUtil.readPluginPackageXml(xml);
        }
        pluginPackage.setContext(servletContextName);
        return pluginPackage;
    }

    public void invokeDeploy(HotDeployEvent event) throws HotDeployException {
        try {
            this.doInvokeDeploy(event);
        }
        catch (Throwable t) {
            this.throwHotDeployException(event, "Error registering plugins for ", t);
        }
    }

    public void invokeUndeploy(HotDeployEvent event) throws HotDeployException {
        try {
            this.doInvokeUndeploy(event);
        }
        catch (Throwable t) {
            this.throwHotDeployException(event, "Error unregistering plugins for ", t);
        }
    }

    protected void destroyServiceComponent(ServletContext servletContext, ClassLoader classLoader) throws Exception {
        ServiceComponentLocalServiceUtil.destroyServiceComponent((ServletContext)servletContext, (ClassLoader)classLoader);
    }

    protected void doInvokeDeploy(HotDeployEvent event) throws Exception {
        ServletContext servletContext = event.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + servletContextName));
        }
        if (servletContext.getResource("/WEB-INF/liferay-theme-loader.xml") != null) {
            return;
        }
        PluginPackage pluginPackage = PluginPackageHotDeployListener.readPluginPackage(servletContext);
        if (pluginPackage == null) {
            return;
        }
        pluginPackage.setContext(servletContextName);
        event.setPluginPackage(pluginPackage);
        PluginPackageUtil.registerInstalledPluginPackage(pluginPackage);
        ClassLoader portletClassLoader = event.getContextClassLoader();
        servletContext.setAttribute("PORTLET_CLASS_LOADER", (Object)portletClassLoader);
        ServletContextPool.put((String)servletContextName, (ServletContext)servletContext);
        this.initServiceComponent(servletContext, portletClassLoader);
        this.registerClpMessageListeners(servletContext, portletClassLoader);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Plugin package " + pluginPackage.getModuleId() + " registered successfully. It's now ready to be used."));
        }
    }

    protected void doInvokeUndeploy(HotDeployEvent event) throws Exception {
        PluginPackage pluginPackage;
        ServletContext servletContext = event.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + servletContextName));
        }
        if ((pluginPackage = PluginPackageHotDeployListener.readPluginPackage(servletContext)) == null) {
            return;
        }
        event.setPluginPackage(pluginPackage);
        PluginPackageUtil.unregisterInstalledPluginPackage(pluginPackage);
        ServletContextPool.remove((String)servletContextName);
        this.destroyServiceComponent(servletContext, event.getContextClassLoader());
        this.unregisterClpMessageListeners(servletContext);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Plugin package " + pluginPackage.getModuleId() + " unregistered successfully"));
        }
    }

    protected void initServiceComponent(ServletContext servletContext, ClassLoader classLoader) throws Exception {
        Configuration serviceBuilderPropertiesConfiguration = null;
        try {
            serviceBuilderPropertiesConfiguration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"service");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to read service.properties");
            }
            return;
        }
        Properties serviceBuilderProperties = serviceBuilderPropertiesConfiguration.getProperties();
        if (serviceBuilderProperties.size() == 0) {
            return;
        }
        String buildNamespace = GetterUtil.getString((String)serviceBuilderProperties.getProperty("build.namespace"));
        long buildNumber = GetterUtil.getLong((String)serviceBuilderProperties.getProperty("build.number"));
        long buildDate = GetterUtil.getLong((String)serviceBuilderProperties.getProperty("build.date"));
        boolean buildAutoUpgrade = GetterUtil.getBoolean((String)serviceBuilderProperties.getProperty("build.auto.upgrade"), (boolean)true);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Build namespace " + buildNamespace));
            _log.debug((Object)("Build number " + buildNumber));
            _log.debug((Object)("Build date " + buildDate));
            _log.debug((Object)("Build auto upgrade " + buildAutoUpgrade));
        }
        if (Validator.isNull((String)buildNamespace)) {
            return;
        }
        ServiceComponentLocalServiceUtil.initServiceComponent((ServletContext)servletContext, (ClassLoader)classLoader, (String)buildNamespace, (long)buildNumber, (long)buildDate, (boolean)buildAutoUpgrade);
    }
}

