/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.auto.exploded.tomcat;

import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;

public abstract class BaseExplodedTomcatListener
implements AutoDeployListener {
    private static Log _log = LogFactoryUtil.getLog(BaseExplodedTomcatListener.class);

    public void copyContextFile(File file) throws AutoDeployException {
        try {
            String tomcatConfDir = PrefsPropsUtil.getString("auto.deploy.tomcat.conf.dir", PropsValues.AUTO_DEPLOY_TOMCAT_CONF_DIR);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Copying file " + file.getPath() + " to " + tomcatConfDir));
            }
            FileUtil.copyFile((File)file, (File)new File(String.valueOf(tomcatConfDir) + "/" + file.getName()));
        }
        catch (Exception e) {
            throw new AutoDeployException(e.getMessage());
        }
    }

    public File getDocBaseDir(File file, String checkXmlFile) throws AutoDeployException {
        if (!this.isMatchingFileExtension(file)) {
            return null;
        }
        String docBase = null;
        try {
            String content = FileUtil.read((File)file);
            Document doc = SAXReaderUtil.read((String)content);
            Element root = doc.getRootElement();
            docBase = root.attributeValue("docBase");
        }
        catch (Exception e) {
            throw new AutoDeployException((Throwable)e);
        }
        if (Validator.isNull((String)docBase)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(String.valueOf(file.getPath()) + " does not have a docBase defined"));
            }
            return null;
        }
        File docBaseDir = new File(docBase);
        if (!docBaseDir.exists()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(String.valueOf(docBase) + " does not exist"));
            }
            return null;
        }
        if (!docBaseDir.isDirectory()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(String.valueOf(docBase) + " is not a directory"));
            }
            return null;
        }
        if (!FileUtil.exists((String)(String.valueOf(docBase) + "/" + checkXmlFile))) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(String.valueOf(docBase) + " does not have " + checkXmlFile));
            }
            return null;
        }
        return docBaseDir;
    }

    public boolean isMatchingFileExtension(File file) {
        if (file.getName().endsWith(".xml")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(String.valueOf(file.getPath()) + " has a matching extension"));
            }
            return true;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(String.valueOf(file.getPath()) + " does not have a matching extension"));
        }
        return false;
    }
}

