/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.jpa;

import com.liferay.portal.dao.orm.jpa.ExceptionTranslator;
import com.liferay.portal.dao.orm.jpa.LockModeTranslator;
import com.liferay.portal.dao.orm.jpa.QueryImpl;
import com.liferay.portal.dao.orm.jpa.SQLQueryImpl;
import com.liferay.portal.kernel.dao.orm.LockMode;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContext;
import javax.persistence.TemporalType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionImpl
implements Session {
    @PersistenceContext
    protected EntityManager _entityManager;

    public void clear() throws ORMException {
        try {
            this._entityManager.clear();
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    public Connection close() throws ORMException {
        return null;
    }

    public boolean contains(Object object) throws ORMException {
        try {
            return this._entityManager.contains(object);
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    public Query createQuery(String queryString) throws ORMException {
        return new QueryImpl(this, queryString);
    }

    public SQLQuery createSQLQuery(String queryString) throws ORMException {
        return new SQLQueryImpl(this, queryString);
    }

    public void delete(Object object) throws ORMException {
        try {
            this._entityManager.remove(this._entityManager.merge(object));
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    public void evict(Object object) throws ORMException {
    }

    public void flush() throws ORMException {
        try {
            this._entityManager.flush();
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    public Object get(Class<?> clazz, Serializable id) throws ORMException {
        try {
            return this._entityManager.find(clazz, (Object)id);
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    public Object get(Class<?> clazz, Serializable id, LockMode lockMode) throws ORMException {
        try {
            Object entity = this._entityManager.find(clazz, (Object)id);
            LockModeType lockModeType = LockModeTranslator.translate(lockMode);
            if (lockModeType != null) {
                this._entityManager.lock(entity, lockModeType);
            }
            return entity;
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    public Object getWrappedSession() throws ORMException {
        return this._entityManager;
    }

    public Object load(Class<?> clazz, Serializable id) throws ORMException {
        try {
            return this._entityManager.getReference(clazz, (Object)id);
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    public Object merge(Object object) throws ORMException {
        try {
            return this._entityManager.merge(object);
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    public Serializable save(Object object) throws ORMException {
        try {
            this._entityManager.persist(object);
            return null;
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    public void saveOrUpdate(Object object) throws ORMException {
        try {
            this._entityManager.merge(object);
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    protected int executeUpdate(String queryString, Map<Integer, Object> parameterMap, int firstResult, int maxResults, FlushModeType flushMode, boolean sqlQuery, Class<?> entityClass) {
        javax.persistence.Query query = this._getExecutableQuery(queryString, parameterMap, firstResult, maxResults, flushMode, sqlQuery, entityClass);
        return query.executeUpdate();
    }

    protected List<?> list(String queryString, Map<Integer, Object> parameterMap, int firstResult, int maxResults, FlushModeType flushMode, boolean sqlQuery, Class<?> entityClass) {
        javax.persistence.Query query = this._getExecutableQuery(queryString, parameterMap, firstResult, maxResults, flushMode, sqlQuery, entityClass);
        return query.getResultList();
    }

    protected Object uniqueResult(String queryString, Map<Integer, Object> parameterMap, int firstResult, int maxResults, FlushModeType flushMode, boolean sqlQuery, Class<?> entityClass) {
        javax.persistence.Query query = this._getExecutableQuery(queryString, parameterMap, firstResult, maxResults, flushMode, sqlQuery, entityClass);
        return query.getSingleResult();
    }

    private javax.persistence.Query _getExecutableQuery(String queryString, Map<Integer, Object> parameterMap, int firstResult, int maxResults, FlushModeType flushMode, boolean sqlQuery, Class<?> entityClass) {
        javax.persistence.Query query = null;
        query = sqlQuery ? (entityClass != null ? this._entityManager.createNativeQuery(queryString, entityClass) : this._entityManager.createNativeQuery(queryString)) : this._entityManager.createQuery(queryString);
        this._setParameters(query, parameterMap);
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        if (flushMode != null) {
            query.setFlushMode(flushMode);
        }
        return query;
    }

    private void _setParameters(javax.persistence.Query query, Map<Integer, Object> parameterMap) {
        for (Map.Entry<Integer, Object> entry : parameterMap.entrySet()) {
            int position = entry.getKey() + 1;
            Object value = entry.getValue();
            if (value instanceof Date) {
                query.setParameter(position, (Date)value, TemporalType.TIMESTAMP);
                continue;
            }
            query.setParameter(position, value);
        }
    }
}

