/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.convert;

import com.liferay.portal.convert.ConvertProcess;
import com.liferay.portal.image.DatabaseHook;
import com.liferay.portal.image.HookFactory;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.image.Hook;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Image;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.portal.util.PropsValues;
import java.io.InputStream;
import java.util.List;

public class ConvertImageGallery
extends ConvertProcess {
    private static final String[] _HOOKS = new String[]{"com.liferay.portal.image.DatabaseHook", "com.liferay.portal.image.DLHook", "com.liferay.portal.image.FileSystemHook"};
    private static Log _log = LogFactoryUtil.getLog(ConvertImageGallery.class);
    private Hook _sourceHook;
    private Hook _targetHook;

    public String getDescription() {
        return "migrate-images-from-one-repository-to-another";
    }

    public String getParameterDescription() {
        return "please-select-a-new-repository-hook";
    }

    public String[] getParameterNames() {
        StringBundler sb = new StringBundler(_HOOKS.length * 2 + 2);
        sb.append("image.hook.impl");
        sb.append("=");
        String[] stringArray = _HOOKS;
        int n = _HOOKS.length;
        int n2 = 0;
        while (n2 < n) {
            String hook = stringArray[n2];
            if (!hook.equals(PropsValues.IMAGE_HOOK_IMPL)) {
                sb.append(hook);
                sb.append(";");
            }
            ++n2;
        }
        return new String[]{sb.toString()};
    }

    public boolean isEnabled() {
        return true;
    }

    protected void doConvert() throws Exception {
        boolean cacheRegistryActive = CacheRegistryUtil.isActive();
        try {
            CacheRegistryUtil.setActive((boolean)false);
            this._sourceHook = HookFactory.getInstance();
            String[] values = this.getParameterValues();
            String targetHookClassName = values[0];
            ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
            this._targetHook = (Hook)classLoader.loadClass(targetHookClassName).newInstance();
            this.migrateImages();
            HookFactory.setInstance(this._targetHook);
            MaintenanceUtil.appendStatus("Please set image.hook.impl in your portal-ext.properties to use " + targetHookClassName);
            if (this._sourceHook instanceof DatabaseHook) {
                DB db = DBFactoryUtil.getDB();
                db.runSQL("update Image set text_ = \"\"");
            }
            PropsValues.IMAGE_HOOK_IMPL = targetHookClassName;
        }
        finally {
            CacheRegistryUtil.setActive((boolean)cacheRegistryActive);
        }
    }

    protected void migrateImage(Image image) throws Exception {
        try {
            InputStream is = this._sourceHook.getImageAsStream(image);
            byte[] bytes = FileUtil.getBytes((InputStream)is);
            this._targetHook.updateImage(image, image.getType(), bytes);
            if (this._targetHook instanceof DatabaseHook) {
                ImageLocalServiceUtil.updateImage((Image)image, (boolean)false);
            }
        }
        catch (Exception e) {
            _log.error((Object)("Migration failed for " + image.getImageId()), (Throwable)e);
        }
    }

    protected void migrateImages() throws Exception {
        int count = ImageLocalServiceUtil.getImagesCount();
        int pages = count / 1000;
        MaintenanceUtil.appendStatus("Migrating " + count + " images");
        int i = 0;
        while (i <= pages) {
            int start = i * 1000;
            int end = start + 1000;
            List images = ImageLocalServiceUtil.getImages((int)start, (int)end);
            for (Image image : images) {
                this.migrateImage(image);
            }
            ++i;
        }
    }
}

