/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.memory;

import com.liferay.portal.kernel.cache.BasePortalCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryPortalCache
extends BasePortalCache {
    private Map<String, Object> _map;

    public MemoryPortalCache(int initialCapacity) {
        this._map = new ConcurrentHashMap<String, Object>(initialCapacity);
    }

    public Collection<Object> get(Collection<String> keys) {
        ArrayList<Object> values = new ArrayList<Object>(keys.size());
        for (String key : keys) {
            values.add(this.get(key));
        }
        return values;
    }

    public Object get(String key) {
        String processedKey = this.processKey(key);
        return this._map.get(processedKey);
    }

    public void put(String key, Object obj) {
        String processedKey = this.processKey(key);
        this._map.put(processedKey, obj);
    }

    public void put(String key, Object obj, int timeToLive) {
        String processedKey = this.processKey(key);
        this._map.put(processedKey, obj);
    }

    public void put(String key, Serializable obj) {
        String processedKey = this.processKey(key);
        this._map.put(processedKey, obj);
    }

    public void put(String key, Serializable obj, int timeToLive) {
        String processedKey = this.processKey(key);
        this._map.put(processedKey, obj);
    }

    public void remove(String key) {
        String processedKey = this.processKey(key);
        this._map.remove(processedKey);
    }

    public void removeAll() {
        this._map.clear();
    }
}

