/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.kernel.cache.BasePortalCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhcachePortalCache
extends BasePortalCache {
    private Ehcache _cache;

    public EhcachePortalCache(Ehcache cache) {
        this._cache = cache;
    }

    public Object get(String key) {
        String processedKey = this.processKey(key);
        Element element = this._cache.get((Serializable)((Object)processedKey));
        if (element == null) {
            return null;
        }
        return element.getObjectValue();
    }

    public Collection<Object> get(Collection<String> keys) {
        ArrayList<Object> values = new ArrayList<Object>(keys.size());
        for (String key : keys) {
            values.add(this.get(key));
        }
        return values;
    }

    public void put(String key, Object obj) {
        Element element = this.createElement(key, obj);
        this._cache.put(element);
    }

    public void put(String key, Object obj, int timeToLive) {
        Element element = this.createElement(key, obj);
        element.setTimeToLive(timeToLive);
        this._cache.put(element);
    }

    public void put(String key, Serializable obj) {
        Element element = this.createElement(key, obj);
        this._cache.put(element);
    }

    public void put(String key, Serializable obj, int timeToLive) {
        Element element = this.createElement(key, obj);
        element.setTimeToLive(timeToLive);
        this._cache.put(element);
    }

    public void remove(String key) {
        String processedKey = this.processKey(key);
        this._cache.remove((Serializable)((Object)processedKey));
    }

    public void removeAll() {
        this._cache.removeAll();
    }

    protected Element createElement(String key, Object obj) {
        String processedKey = this.processKey(key);
        Element element = new Element((Object)processedKey, obj);
        return element;
    }
}

